/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclonedx.model.Ancestors;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ComponentWrapper;
import org.cyclonedx.model.Descendants;
import org.cyclonedx.model.Variants;

public class ComponentWrapperDeserializer
extends JsonDeserializer<ComponentWrapper> {
    private static final String ANCESTORS = "ancestors";
    private static final String DESCENDANTS = "descendants";
    private static final String VARIANTS = "variants";

    public ComponentWrapper deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectNode node;
        ComponentWrapper wrapper;
        String location = parser.getCurrentName();
        if (parser instanceof FromXmlParser) {
            switch (location) {
                case "ancestors": {
                    return (ComponentWrapper)parser.readValueAs(Ancestors.class);
                }
                case "descendants": {
                    return (ComponentWrapper)parser.readValueAs(Descendants.class);
                }
                case "variants": {
                    return (ComponentWrapper)parser.readValueAs(Variants.class);
                }
            }
            return null;
        }
        switch (location) {
            case "ancestors": {
                wrapper = new Ancestors();
                break;
            }
            case "descendants": {
                wrapper = new Descendants();
                break;
            }
            case "variants": {
                wrapper = new Variants();
                break;
            }
            default: {
                return null;
            }
        }
        List<Component> components = Collections.emptyList();
        JsonToken currentToken = parser.currentToken();
        if (currentToken == JsonToken.START_ARRAY) {
            components = Arrays.asList((Component[])parser.readValueAs(Component[].class));
        } else if (currentToken == JsonToken.START_OBJECT && (node = (ObjectNode)parser.readValueAs(ObjectNode.class)).has("component")) {
            JsonNode component = node.get("component");
            try (JsonParser componentsParser = component.traverse(parser.getCodec());){
                components = component.isArray() ? Arrays.asList((Component[])componentsParser.readValueAs(Component[].class)) : Collections.singletonList((Component)componentsParser.readValueAs(Component.class));
            }
        }
        wrapper.setComponents(components);
        return wrapper;
    }
}

