/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclonedx.model.Component;

public class ComponentListDeserializer
extends JsonDeserializer<List<Component>> {
    public List<Component> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken currentToken = parser.getCurrentToken();
        if (currentToken == JsonToken.START_ARRAY) {
            return Arrays.asList((Component[])parser.readValueAs(Component[].class));
        }
        if (currentToken == JsonToken.START_OBJECT) {
            ObjectMapper mapper = this.getMapper(parser);
            ObjectNode node = (ObjectNode)parser.readValueAs(ObjectNode.class);
            if (node.has("component")) {
                JsonNode componentNode = node.get("component");
                return this.deserializeComponentNode(componentNode, parser, mapper);
            }
            Component component = (Component)mapper.convertValue((Object)node, Component.class);
            return Collections.singletonList(component);
        }
        if (currentToken == JsonToken.VALUE_NULL) {
            return null;
        }
        ObjectMapper mapper = this.getMapper(parser);
        Component component = (Component)parser.readValueAs(Component.class);
        return Collections.singletonList(component);
    }

    private List<Component> deserializeComponentNode(JsonNode componentNode, JsonParser originalParser, ObjectMapper mapper) throws IOException {
        try (JsonParser componentParser = componentNode.traverse(originalParser.getCodec());){
            componentParser.nextToken();
            if (componentNode.isArray()) {
                List<Component> list = Arrays.asList((Component[])componentParser.readValueAs(Component[].class));
                return list;
            }
            Component component = (Component)componentParser.readValueAs(Component.class);
            List<Component> list = Collections.singletonList(component);
            return list;
        }
    }

    private ObjectMapper getMapper(JsonParser parser) {
        if (parser.getCodec() instanceof ObjectMapper) {
            return (ObjectMapper)parser.getCodec();
        }
        return new ObjectMapper();
    }
}

