/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.cyclonedx.model.AttachmentText;

public class AttachmentTextDeserializer
extends StdDeserializer<AttachmentText> {
    public AttachmentTextDeserializer() {
        this(null);
    }

    public AttachmentTextDeserializer(Class<?> vc) {
        super(vc);
    }

    public AttachmentText deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode encodingNode;
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        AttachmentText attachmentText = new AttachmentText();
        JsonNode contentNode = node.get("content");
        if (contentNode != null) {
            attachmentText.setText(contentNode.asText());
        } else if (node.has("")) {
            attachmentText.setText(node.get("").asText());
        } else if (node.isTextual()) {
            attachmentText.setText(node.textValue());
        }
        JsonNode contentTypeNode = this.getContentTypeNode(node);
        if (contentTypeNode != null && contentTypeNode.isTextual()) {
            attachmentText.setContentType(contentTypeNode.asText());
        }
        if ((encodingNode = node.get("encoding")) != null && encodingNode.isTextual()) {
            attachmentText.setEncoding(encodingNode.asText());
        }
        return attachmentText;
    }

    private JsonNode getContentTypeNode(JsonNode node) {
        JsonNode contentTypeNode = node.get("content-type");
        if (contentTypeNode == null || !contentTypeNode.isTextual()) {
            contentTypeNode = node.get("contentType");
        }
        return contentTypeNode;
    }
}

