/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.cyclonedx.model.vulnerability.Vulnerability;

public class AffectDeserializer
extends JsonDeserializer<Vulnerability.Affect> {
    private final ObjectMapper mapper = new ObjectMapper();

    public Vulnerability.Affect deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode versionsNode;
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        Vulnerability.Affect affect = new Vulnerability.Affect();
        JsonNode refNode = node.get("ref");
        if (refNode != null) {
            affect.setRef(refNode.asText());
        }
        if ((versionsNode = node.get("versions")) != null) {
            if (versionsNode.isArray()) {
                List versions = (List)this.mapper.convertValue((Object)node.get("versions"), (TypeReference)new TypeReference<List<Vulnerability.Version>>(){});
                affect.setVersions(versions);
            } else if (versionsNode.has("version")) {
                JsonNode versionNode = versionsNode.get("version");
                if (versionNode.isArray()) {
                    List versions = (List)this.mapper.convertValue((Object)versionNode, (TypeReference)new TypeReference<List<Vulnerability.Version>>(){});
                    affect.setVersions(versions);
                } else {
                    affect.addVersion((Vulnerability.Version)this.mapper.convertValue((Object)versionNode, Vulnerability.Version.class));
                }
            }
        }
        return affect;
    }
}

