/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.cyclonedx.Version;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.VersionFilter;

public final class BomUtils {
    private BomUtils() {
    }

    public static List<Hash> calculateHashes(File file, Version schemaVersion) throws IOException {
        LinkedList<Hash.Algorithm> algorithms = new LinkedList<Hash.Algorithm>(Arrays.asList(Hash.Algorithm.MD5, Hash.Algorithm.SHA1, Hash.Algorithm.SHA_256, Hash.Algorithm.SHA_512, Hash.Algorithm.SHA3_256, Hash.Algorithm.SHA3_512));
        if (schemaVersion.getVersion() >= 1.2) {
            algorithms.add(Hash.Algorithm.SHA_384);
            algorithms.add(Hash.Algorithm.SHA3_384);
        }
        return BomUtils.calculateHashes(file, schemaVersion, algorithms);
    }

    public static List<Hash> calculateHashes(File file, Version schemaVersion, List<Hash.Algorithm> algorithms) throws IOException {
        if (!(file != null && file.exists() && file.canRead() && file.isFile())) {
            return null;
        }
        if (algorithms == null || algorithms.isEmpty()) {
            return new LinkedList<Hash>();
        }
        LinkedList<Hash> hashes = new LinkedList<Hash>();
        LinkedList<MessageDigest> digests = new LinkedList<MessageDigest>();
        for (Hash.Algorithm algorithm : algorithms) {
            BomUtils.validateAlgorithmForVersion(algorithm, schemaVersion);
            MessageDigest digest = BomUtils.getDigestForAlgorithm(algorithm);
            if (digest == null) continue;
            digests.add(digest);
        }
        int bufSize = 8192;
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), 8192);){
            byte[] buf = new byte[8192];
            while (((InputStream)fis).available() > 0) {
                int read = ((InputStream)fis).read(buf);
                ((Stream)digests.stream().parallel()).forEach(d -> d.update(buf, 0, read));
            }
        }
        digests.stream().map(d -> new Hash(BomUtils.toAlgorithm(d), Hex.encodeHexString((byte[])d.digest()))).forEach(hashes::add);
        return hashes;
    }

    private static void validateAlgorithmForVersion(Hash.Algorithm algorithm, Version schemaVersion) {
        try {
            Field field = Hash.Algorithm.class.getField(algorithm.name());
            VersionFilter versionFilter = field.getAnnotation(VersionFilter.class);
            if (versionFilter != null) {
                Version minVersion = versionFilter.value();
                if (schemaVersion.getVersion() < minVersion.getVersion()) {
                    throw new IllegalArgumentException("Algorithm " + algorithm.getSpec() + " is not supported in schema version " + String.valueOf((Object)schemaVersion) + ". Minimum required version: " + String.valueOf((Object)minVersion));
                }
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Unknown algorithm: " + String.valueOf((Object)algorithm));
        }
    }

    private static MessageDigest getDigestForAlgorithm(Hash.Algorithm algorithm) {
        try {
            switch (algorithm) {
                case MD5: {
                    return DigestUtils.getMd5Digest();
                }
                case SHA1: {
                    return DigestUtils.getSha1Digest();
                }
                case SHA_256: {
                    return DigestUtils.getSha256Digest();
                }
                case SHA_384: {
                    return DigestUtils.getSha384Digest();
                }
                case SHA_512: {
                    return DigestUtils.getSha512Digest();
                }
                case SHA3_256: {
                    return DigestUtils.getSha3_256Digest();
                }
                case SHA3_384: {
                    return DigestUtils.getSha3_384Digest();
                }
                case SHA3_512: {
                    return DigestUtils.getSha3_512Digest();
                }
                case BLAKE2b_256: 
                case BLAKE2b_384: 
                case BLAKE2b_512: 
                case BLAKE3: {
                    return MessageDigest.getInstance(algorithm.getSpec());
                }
            }
            throw new IllegalArgumentException("Unsupported algorithm: " + algorithm.getSpec());
        }
        catch (NoSuchMethodError | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Algorithm not available: " + algorithm.getSpec(), e);
        }
    }

    private static Hash.Algorithm toAlgorithm(MessageDigest digest) {
        for (Hash.Algorithm value : Hash.Algorithm.values()) {
            if (!value.getSpec().equals(digest.getAlgorithm())) continue;
            return value;
        }
        throw new IllegalArgumentException("Unable to find algorithm matching '" + digest.getAlgorithm() + "'. Known algorithms: " + Arrays.stream(Hash.Algorithm.values()).map(Hash.Algorithm::getSpec).sorted().collect(Collectors.joining()));
    }

    @Deprecated
    public static boolean validateUrlString(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    public static boolean validateUriString(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

