/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Lifecycles;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.util.TimestampUtils;
import org.cyclonedx.util.ToolsJsonParser;
import org.cyclonedx.util.deserializer.LicenseDeserializer;
import org.cyclonedx.util.deserializer.LifecycleDeserializer;
import org.cyclonedx.util.deserializer.PropertiesDeserializer;

public class MetadataDeserializer
extends JsonDeserializer<Metadata> {
    private final LifecycleDeserializer lifecycleDeserializer = new LifecycleDeserializer();
    private final PropertiesDeserializer propertiesDeserializer = new PropertiesDeserializer();
    private final LicenseDeserializer licenseDeserializer = new LicenseDeserializer();

    public Metadata deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Metadata metadata = new Metadata();
        ObjectMapper mapper = this.getMapper(jsonParser);
        if (node.has("authors")) {
            JsonNode authorsNode = node.get("authors");
            List<OrganizationalContact> authors = MetadataDeserializer.deserializeOrganizationalContact(authorsNode, mapper);
            metadata.setAuthors(authors);
        }
        if (node.has("component")) {
            Component component = this.deserializeComponent(node.get("component"), jsonParser, mapper);
            metadata.setComponent(component);
        }
        if (node.has("manufacture")) {
            OrganizationalEntity manufacture = (OrganizationalEntity)mapper.convertValue((Object)node.get("manufacture"), OrganizationalEntity.class);
            metadata.setManufacture(manufacture);
        }
        if (node.has("manufacturer")) {
            OrganizationalEntity manufacturer = (OrganizationalEntity)mapper.convertValue((Object)node.get("manufacturer"), OrganizationalEntity.class);
            metadata.setManufacturer(manufacturer);
        }
        if (node.has("lifecycles")) {
            JsonParser lifecycleParser = node.get("lifecycles").traverse(jsonParser.getCodec());
            lifecycleParser.nextToken();
            Lifecycles lifecycles = this.lifecycleDeserializer.deserialize(lifecycleParser, ctxt);
            metadata.setLifecycles(lifecycles);
        }
        if (node.has("supplier")) {
            OrganizationalEntity supplier = (OrganizationalEntity)mapper.convertValue((Object)node.get("supplier"), OrganizationalEntity.class);
            metadata.setSupplier(supplier);
        }
        if (node.has("licenses")) {
            JsonParser licensesParser = node.get("licenses").traverse(jsonParser.getCodec());
            licensesParser.nextToken();
            LicenseChoice licenses = this.licenseDeserializer.deserialize(licensesParser, ctxt);
            metadata.setLicenses(licenses);
        }
        if (node.has("timestamp")) {
            this.setTimestamp(node, metadata);
        }
        if (node.has("properties")) {
            JsonParser propertiesParser = node.get("properties").traverse(jsonParser.getCodec());
            propertiesParser.nextToken();
            Object properties = this.propertiesDeserializer.deserialize(propertiesParser, ctxt);
            metadata.setProperties((List<Property>)properties);
        }
        if (node.has("tools")) {
            ToolsJsonParser toolsParser = new ToolsJsonParser(node, jsonParser, ctxt);
            metadata.setTools(toolsParser.getTools());
            metadata.setToolChoice(toolsParser.getToolInformation());
        }
        return metadata;
    }

    static List<OrganizationalContact> deserializeOrganizationalContact(JsonNode node, ObjectMapper mapper) {
        ArrayList<OrganizationalContact> organizationalContactList = new ArrayList<OrganizationalContact>();
        if (node.has("author")) {
            node = node.get("author");
        }
        if (node.isArray()) {
            for (JsonNode authorNode : node) {
                MetadataDeserializer.deserializeAuthor(authorNode, mapper, organizationalContactList);
            }
        } else if (node.isObject()) {
            MetadataDeserializer.deserializeAuthor(node, mapper, organizationalContactList);
        }
        return organizationalContactList;
    }

    static void deserializeAuthor(JsonNode node, ObjectMapper mapper, List<OrganizationalContact> organizationalContactList) {
        OrganizationalContact author = (OrganizationalContact)mapper.convertValue((Object)node, OrganizationalContact.class);
        organizationalContactList.add(author);
    }

    private ObjectMapper getMapper(JsonParser jsonParser) {
        if (jsonParser.getCodec() instanceof ObjectMapper) {
            return (ObjectMapper)jsonParser.getCodec();
        }
        return new ObjectMapper();
    }

    private void setTimestamp(JsonNode node, Metadata metadata) {
        JsonNode timestampNode = node.get("timestamp");
        if (timestampNode != null && timestampNode.isTextual()) {
            metadata.setTimestamp(TimestampUtils.parseTimestamp(timestampNode.textValue()));
        }
    }

    private Component deserializeComponent(JsonNode componentNode, JsonParser originalParser, ObjectMapper mapper) throws IOException {
        try (JsonParser componentParser = componentNode.traverse(originalParser.getCodec());){
            componentParser.nextToken();
            Component component = (Component)componentParser.readValueAs(Component.class);
            return component;
        }
    }
}

