/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mailsender.javamail;

import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.codehaus.plexus.mailsender.AbstractMailSender;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.codehaus.plexus.mailsender.util.DateFormatUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractJavamailMailSender
extends AbstractMailSender {
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_SMTP_USER = "mail.smtp.user";
    public static final String MAIL_SMTP_PASSWORD = "password";
    public static final String MAIL_SMTP_SOCKETFACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String MAIL_SMTP_SOCKETFACTORY_CLASS = "mail.smtp.socketFactory.class";
    public static final String MAIL_SMTP_SOCKETFACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    public static final String MAIL_SMTP_TIMEOUT = "mail.smtp.timeout";
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_SMTP_DEBUG = "mail.smtp.debug";
    public static final String MAIL_SMTP_QUITWAIT = "mail.smtp.quitwait";
    public static final String MAIL_SMTP_DEBUG2 = "mail.debug";
    private Properties props = new Properties();

    public abstract Session getSession() throws MailSenderException;

    public void send(MailMessage mail) throws MailSenderException {
        this.verify(mail);
        Session session = this.getSession();
        if (this.isDebugMode()) {
            session.setDebug(true);
        } else if (StringUtils.isNotEmpty((String)session.getProperty(MAIL_SMTP_DEBUG))) {
            session.setDebug(new Boolean(session.getProperty(MAIL_SMTP_DEBUG)).booleanValue());
        } else if (StringUtils.isNotEmpty((String)session.getProperty(MAIL_SMTP_DEBUG2))) {
            session.setDebug(new Boolean(session.getProperty(MAIL_SMTP_DEBUG2)).booleanValue());
        } else if (this.getLogger() != null) {
            session.setDebug(this.getLogger().isDebugEnabled());
        }
        try {
            String port;
            String address;
            Iterator i;
            int count;
            MimeMessage message = new MimeMessage(session);
            InternetAddress fromAddress = new InternetAddress(mail.getFrom().getRfc2822Address());
            message.setFrom((Address)fromAddress);
            Address[] replyToAddresses = new Address[]{new InternetAddress(mail.getReplyTo().getRfc2822Address())};
            message.setReplyTo(replyToAddresses);
            if (mail.getToAddresses().size() > 0) {
                InternetAddress[] addressTo = new InternetAddress[mail.getToAddresses().size()];
                count = 0;
                i = mail.getToAddresses().iterator();
                while (i.hasNext()) {
                    address = ((MailMessage.Address)i.next()).getRfc2822Address();
                    addressTo[count++] = new InternetAddress(address);
                }
                message.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
            }
            if (mail.getCcAddresses().size() > 0) {
                InternetAddress[] addressCc = new InternetAddress[mail.getCcAddresses().size()];
                count = 0;
                i = mail.getCcAddresses().iterator();
                while (i.hasNext()) {
                    address = ((MailMessage.Address)i.next()).getRfc2822Address();
                    addressCc[count++] = new InternetAddress(address);
                }
                message.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
            }
            if (mail.getBccAddresses().size() > 0) {
                InternetAddress[] addressBcc = new InternetAddress[mail.getBccAddresses().size()];
                count = 0;
                i = mail.getBccAddresses().iterator();
                while (i.hasNext()) {
                    address = ((MailMessage.Address)i.next()).getRfc2822Address();
                    addressBcc[count++] = new InternetAddress(address);
                }
                message.setRecipients(Message.RecipientType.BCC, (Address[])addressBcc);
            }
            message.setSubject(mail.getSubject());
            if ("html".equals(mail.getContentType())) {
                message.setContent((Object)mail.getContent(), "text/html");
            } else {
                message.setContent((Object)mail.getContent(), "text/plain; format=flowed");
            }
            if (mail.getSendDate() != null) {
                message.setHeader("Date", DateFormatUtils.getDateHeader((Date)mail.getSendDate()));
            } else {
                message.setHeader("Date", DateFormatUtils.getDateHeader((Date)new Date()));
            }
            message.saveChanges();
            String protocol = "smtp";
            if (StringUtils.isNotEmpty((String)session.getProperty(MAIL_TRANSPORT_PROTOCOL))) {
                protocol = session.getProperty(MAIL_TRANSPORT_PROTOCOL);
            }
            if (StringUtils.isEmpty((String)(port = session.getProperty(MAIL_SMTP_PORT)))) {
                port = protocol.endsWith("s") ? "465" : "25";
            }
            Transport transport = session.getTransport(protocol);
            transport.connect(session.getProperty(MAIL_SMTP_HOST), new Integer(port).intValue(), session.getProperty(MAIL_SMTP_USER), session.getProperty(MAIL_SMTP_PASSWORD));
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (SendFailedException e) {
            throw new MailSenderException("Error while sending the message.", (Throwable)e);
        }
        catch (MessagingException e) {
            throw new MailSenderException("Error while sending the message.", (Throwable)e);
        }
        catch (Exception e) {
            throw new MailSenderException("Error while sending the message.", (Throwable)e);
        }
    }

    protected Properties getProperties() {
        return this.props;
    }

    protected void addProperty(String key, String value) {
        this.props.put(key, value);
    }

    protected void removeProperty(String key) {
        this.props.remove(key);
    }

    public void setSmtpHost(String host) {
        super.setSmtpHost(host);
        if (StringUtils.isNotEmpty((String)host)) {
            this.addProperty(MAIL_SMTP_HOST, host);
        } else {
            this.removeProperty(MAIL_SMTP_HOST);
        }
    }

    public void setSmtpPort(int port) {
        super.setSmtpPort(port);
        this.addProperty(MAIL_SMTP_PORT, String.valueOf(port));
    }

    public void setUsername(String username) {
        super.setUsername(username);
        if (StringUtils.isNotEmpty((String)username)) {
            this.addProperty(MAIL_SMTP_USER, username);
            this.addProperty(MAIL_SMTP_AUTH, "true");
        } else {
            this.removeProperty(MAIL_SMTP_AUTH);
        }
    }

    public void setPassword(String password) {
        super.setPassword(password);
        if (StringUtils.isNotEmpty((String)password)) {
            this.addProperty(MAIL_SMTP_PASSWORD, password);
        }
    }
}

