/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.builder.ComponentBuilder;
import org.codehaus.plexus.component.builder.XBeanComponentBuilder;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentManager<T>
implements ComponentManager<T> {
    private final MutablePlexusContainer container;
    private final ComponentDescriptor<T> componentDescriptor;
    private final ComponentBuilder<T> builder = new XBeanComponentBuilder(this);
    private final LifecycleHandler lifecycleHandler;
    private long startId;

    public AbstractComponentManager(MutablePlexusContainer container, LifecycleHandler lifecycleHandler, ComponentDescriptor<T> componentDescriptor) {
        if (container == null) {
            throw new NullPointerException("container is null");
        }
        this.container = container;
        if (lifecycleHandler == null) {
            throw new NullPointerException("lifecycleHandler is null");
        }
        this.lifecycleHandler = lifecycleHandler;
        if (componentDescriptor == null) {
            throw new NullPointerException("componentDescriptor is null");
        }
        this.componentDescriptor = componentDescriptor;
    }

    @Override
    public ComponentDescriptor<T> getComponentDescriptor() {
        return this.componentDescriptor;
    }

    @Override
    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    protected T createInstance() throws ComponentInstantiationException, ComponentLifecycleException {
        return this.builder.build(this.componentDescriptor, this.componentDescriptor.getRealm(), null);
    }

    protected void destroyInstance(Object component) throws ComponentLifecycleException {
        try {
            this.lifecycleHandler.end(component, this, this.componentDescriptor.getRealm());
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error ending component lifecycle", e);
        }
    }

    @Override
    public void start(Object component) throws PhaseExecutionException {
        this.startId = NEXT_START_ID.getAndIncrement();
        this.getLifecycleHandler().start(component, this, this.componentDescriptor.getRealm());
    }

    @Override
    public long getStartId() {
        return this.startId;
    }

    @Override
    public MutablePlexusContainer getContainer() {
        return this.container;
    }
}

