/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang.BooleanUtils;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.codehaus.mojo.webstart.generator.GeneratorExtraConfig;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public abstract class AbstractGenerator {
    private VelocityEngine engine;
    private final MavenProject mavenProject;
    private Template velocityTemplate;
    private final File outputFile;
    private final String mainClass;
    private GeneratorExtraConfig extraConfig;

    protected AbstractGenerator(MavenProject mavenProject, File resourceLoaderPath, String defaultTemplateResourceName, File outputFile, String inputFileTemplatePath, String mainClass, String webstartJarURL) {
        if (mavenProject == null) {
            throw new IllegalArgumentException("mavenProject must not be null");
        }
        if (resourceLoaderPath == null) {
            throw new IllegalArgumentException("resourceLoaderPath must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("outputFile must not be null");
        }
        if (mainClass == null) {
            throw new IllegalArgumentException("mainClass must not be null");
        }
        this.outputFile = outputFile;
        this.mainClass = mainClass;
        this.mavenProject = mavenProject;
        Properties props = new Properties();
        if (inputFileTemplatePath != null) {
            props.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
            props.setProperty("file.resource.loader.path", resourceLoaderPath.getAbsolutePath());
            this.initVelocity(props);
            if (!this.engine.templateExists(inputFileTemplatePath)) {
                System.out.println("Warning, template not found. Will probably fail.");
            }
        } else {
            System.out.println("No template specified Using default one.");
            inputFileTemplatePath = defaultTemplateResourceName;
            System.out.println("***** Webstart JAR URL: " + webstartJarURL);
            props = new Properties();
            props.setProperty("resource.loader", "jar");
            props.setProperty("jar.resource.loader.description", "Jar resource loader for default webstart templates");
            props.setProperty("jar.resource.loader.class", "org.apache.velocity.runtime.resource.loader.JarResourceLoader");
            props.setProperty("jar.resource.loader.path", webstartJarURL);
            this.initVelocity(props);
            if (!this.engine.templateExists(inputFileTemplatePath)) {
                System.out.println("Inbuilt template not found!! " + defaultTemplateResourceName + " Will probably fail.");
            }
        }
        try {
            this.velocityTemplate = this.engine.getTemplate(inputFileTemplatePath);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not load the template file from '" + inputFileTemplatePath + "'");
            iae.initCause(e);
            throw iae;
        }
    }

    private void initVelocity(Properties props) {
        try {
            this.engine = new VelocityEngine();
            this.engine.setProperty("runtime.log.logsystem", (Object)new NullLogSystem());
            this.engine.init(props);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not initialise Velocity");
            iae.initCause(e);
            throw iae;
        }
    }

    public void setExtraConfig(GeneratorExtraConfig extraConfig) {
        this.extraConfig = extraConfig;
    }

    public final void generate() throws Exception {
        VelocityContext context = this.createAndPopulateContext();
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)this.outputFile);
        try {
            this.velocityTemplate.merge((Context)context, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new Exception("Could not generate the template " + this.velocityTemplate.getName() + ": " + e.getMessage(), e);
        }
        finally {
            writer.close();
        }
    }

    protected abstract String getDependenciesText();

    protected VelocityContext createAndPopulateContext() {
        VelocityContext context = new VelocityContext();
        context.put("dependencies", (Object)this.getDependenciesText());
        this.addPropertiesToContext(System.getProperties(), context);
        this.addPropertiesToContext(this.mavenProject.getProperties(), context);
        context.put("project", (Object)this.mavenProject.getModel());
        context.put("jnlpCodebase", (Object)this.extraConfig.getJnlpCodeBase());
        context.put("informationTitle", (Object)this.mavenProject.getModel().getName());
        context.put("informationDescription", (Object)this.mavenProject.getModel().getDescription());
        if (this.mavenProject.getModel().getOrganization() != null) {
            context.put("informationVendor", (Object)this.mavenProject.getModel().getOrganization().getName());
            context.put("informationHomepage", (Object)this.mavenProject.getModel().getOrganization().getUrl());
        }
        Date timestamp = new Date();
        context.put("explicitTimestamp", (Object)this.dateToExplicitTimestamp(timestamp));
        context.put("explicitTimestampUTC", (Object)this.dateToExplicitTimestampUTC(timestamp));
        context.put("outputFile", (Object)this.outputFile.getName());
        context.put("mainClass", (Object)this.mainClass);
        context.put("allPermissions", (Object)BooleanUtils.toBoolean((String)this.extraConfig.getAllPermissions()));
        context.put("offlineAllowed", (Object)BooleanUtils.toBoolean((String)this.extraConfig.getOfflineAllowed()));
        context.put("jnlpspec", (Object)this.extraConfig.getJnlpSpec());
        context.put("j2seVersion", (Object)this.extraConfig.getJ2seVersion());
        return context;
    }

    private void addPropertiesToContext(Properties properties, VelocityContext context) {
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String nextKey = (String)iter.next();
            String nextValue = properties.getProperty(nextKey);
            context.put(nextKey, (Object)nextValue);
        }
    }

    private String dateToExplicitTimestamp(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        return "TS: " + df.format(date);
    }

    private String dateToExplicitTimestampUTC(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return "TS: " + df.format(date) + "Z";
    }

    protected String indentText(int level, String text) {
        int i;
        StringBuffer buffer = new StringBuffer();
        String[] lines = text.split("\n");
        String prefix = "";
        for (i = 0; i < level; ++i) {
            prefix = prefix + " ";
        }
        int j = lines.length;
        for (i = 0; i < j; ++i) {
            buffer.append(prefix).append(lines[i]).append("\n");
        }
        return buffer.toString();
    }
}

