/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo.webstart:webstart-maven-plugin:1.0-beta-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "MWEBSTART :: Webstart Maven Plugin", 0);
        this.append(sb, "Maven plugin that supports webstart application development. Helps generate JNLP files and supports the JnlpDownloadServlet.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 7 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "webstart:help", 0);
            this.append(sb, "Display help information on webstart-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0webstart:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jnlp".equals(this.goal)) {
            this.append(sb, "webstart:jnlp", 0);
            this.append(sb, "Packages a jnlp application.\nThe plugin tries to not re-sign\nre-pack if the dependent jar hasn't changed. As a consequence, if one modifies the pom jnlp config or a keystore, one should clean before rebuilding.\nThis mojo forks a build lifecycle and won't install the zip packages in your local repository. You probably want to use the jnlp-inline instead.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attachArchive (Default: true)", 2);
                this.append(sb, "Flag to attach the archive or not to the project's build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUnsign (Default: true)", 2);
                this.append(sb, "To authorize or not to unsign some already signed jar.\nIf set to false and the unsign parameter is set to true then the build will fail if there is a jar to unsign, to avoid this use then the extension jnlp component.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "codebase (Default: ${project.url}/jnlp)", 2);
                this.append(sb, "The code base to use on the generated jnlp files.", 3);
                this.append(sb, "Expression: ${jnlp.codebase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependencies", 2);
                this.append(sb, "[optional] transitive dependencies filter - if omitted, the plugin will include all transitive dependencies. Provided and test scope dependencies are always excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeTransitive", 2);
                this.append(sb, "Set to true to exclude all transitive dependencies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gzip (Default: false)", 2);
                this.append(sb, "Indicates whether or not gzip archives will be created for each of the jar files included in the webstart bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jnlp", 2);
                this.append(sb, "The jnlp configuration element.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jnlpExtensions", 2);
                this.append(sb, "[optional] extensions configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "A placeholder for an obsoleted configuration element.\nThis dummy parameter is here to force the plugin configuration to fail in case one didn't properly migrate from 1.0-alpha-1 to 1.0-alpha-2 configuration.\n\nIt will be removed before 1.0.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "libPath", 2);
                this.append(sb, "The path where the libraries are placed within the jnlp structure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "makeArchive (Default: true)", 2);
                this.append(sb, "Flag to create the archive or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputJarVersions (Default: false)", 2);
                this.append(sb, "When set to true, this flag indicates that a version attribute should be output in each of the jar resource elements in the generated JNLP file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pack200 (Default: false)", 2);
                this.append(sb, "Indicates whether or not jar resources should be compressed using pack200. Setting this value to true requires SDK 5.0 or greater.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourcesDirectory", 2);
                this.append(sb, "The location of the directory (relative or absolute) containing non-jar resources that are to be included in the JNLP bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sign", 2);
                this.append(sb, "The Sign Config", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: ${project.basedir}/src/main/jnlp)", 2);
                this.append(sb, "The location where the JNLP Velocity template files are stored.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "unsignAlreadySignedJars (Default: false)", 2);
                this.append(sb, "Define whether to remove existing signatures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose output.", 3);
                this.append(sb, "Expression: ${verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyjar (Default: true)", 2);
                this.append(sb, "Indicates whether or not jar files should be verified after signing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory (Default: ${project.build.directory}/jnlp)", 2);
                this.append(sb, "The directory in which files will be stored prior to processing.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jnlp-download-servlet".equals(this.goal)) {
            this.append(sb, "webstart:jnlp-download-servlet", 0);
            this.append(sb, "This MOJO is tailored for use within a Maven web application project that uses the JnlpDownloadServlet to serve up the JNLP application.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attachArchive (Default: true)", 2);
                this.append(sb, "Flag to attach the archive or not to the project's build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUnsign (Default: true)", 2);
                this.append(sb, "To authorize or not to unsign some already signed jar.\nIf set to false and the unsign parameter is set to true then the build will fail if there is a jar to unsign, to avoid this use then the extension jnlp component.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "codebase (Default: ${project.url}/jnlp)", 2);
                this.append(sb, "The code base to use on the generated jnlp files.", 3);
                this.append(sb, "Expression: ${jnlp.codebase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "commonJarResources", 2);
                this.append(sb, "The configurable collection of jars that are common to all jnlpFile elements declared in plugin configuration. These jars will be output as jar elements in the resources section of every generated JNLP file and bundled into the specified output directory of the artifact produced by the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeTransitive", 2);
                this.append(sb, "Set to true to exclude all transitive dependencies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gzip (Default: false)", 2);
                this.append(sb, "Indicates whether or not gzip archives will be created for each of the jar files included in the webstart bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jnlpFiles", 2);
                this.append(sb, "The collection of JnlpFile configuration elements. Each one represents a JNLP file that is to be generated and deployed within the enclosing project's WAR artifact. At least one JnlpFile must be specified.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "libPath", 2);
                this.append(sb, "The path where the libraries are placed within the jnlp structure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "makeArchive (Default: true)", 2);
                this.append(sb, "Flag to create the archive or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectoryName (Default: webstart)", 2);
                this.append(sb, "The name of the directory into which the jnlp file and other artifacts will be stored after processing. This directory will be created directly within the root of the WAR produced by the enclosing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pack200 (Default: false)", 2);
                this.append(sb, "Indicates whether or not jar resources should be compressed using pack200. Setting this value to true requires SDK 5.0 or greater.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourcesDirectory", 2);
                this.append(sb, "The location of the directory (relative or absolute) containing non-jar resources that are to be included in the JNLP bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sign", 2);
                this.append(sb, "The Sign Config", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: ${project.basedir}/src/main/jnlp)", 2);
                this.append(sb, "The location where the JNLP Velocity template files are stored.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "unsignAlreadySignedJars (Default: false)", 2);
                this.append(sb, "Define whether to remove existing signatures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose output.", 3);
                this.append(sb, "Expression: ${verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyjar (Default: true)", 2);
                this.append(sb, "Indicates whether or not jar files should be verified after signing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory (Default: ${project.build.directory}/jnlp)", 2);
                this.append(sb, "The directory in which files will be stored prior to processing.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jnlp-inline".equals(this.goal)) {
            this.append(sb, "webstart:jnlp-inline", 0);
            this.append(sb, "Packages a jnlp application without launching a parallel lifecycle build.\nThe plugin tries to not re-sign\nre-pack if the dependent jar hasn't changed. As a consequence, if one modifies the pom jnlp config or a keystore, one should clean before rebuilding.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attachArchive (Default: true)", 2);
                this.append(sb, "Flag to attach the archive or not to the project's build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUnsign (Default: true)", 2);
                this.append(sb, "To authorize or not to unsign some already signed jar.\nIf set to false and the unsign parameter is set to true then the build will fail if there is a jar to unsign, to avoid this use then the extension jnlp component.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "codebase (Default: ${project.url}/jnlp)", 2);
                this.append(sb, "The code base to use on the generated jnlp files.", 3);
                this.append(sb, "Expression: ${jnlp.codebase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependencies", 2);
                this.append(sb, "[optional] transitive dependencies filter - if omitted, the plugin will include all transitive dependencies. Provided and test scope dependencies are always excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeTransitive", 2);
                this.append(sb, "Set to true to exclude all transitive dependencies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gzip (Default: false)", 2);
                this.append(sb, "Indicates whether or not gzip archives will be created for each of the jar files included in the webstart bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jnlp", 2);
                this.append(sb, "The jnlp configuration element.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jnlpExtensions", 2);
                this.append(sb, "[optional] extensions configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "A placeholder for an obsoleted configuration element.\nThis dummy parameter is here to force the plugin configuration to fail in case one didn't properly migrate from 1.0-alpha-1 to 1.0-alpha-2 configuration.\n\nIt will be removed before 1.0.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "libPath", 2);
                this.append(sb, "The path where the libraries are placed within the jnlp structure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "makeArchive (Default: true)", 2);
                this.append(sb, "Flag to create the archive or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputJarVersions (Default: false)", 2);
                this.append(sb, "When set to true, this flag indicates that a version attribute should be output in each of the jar resource elements in the generated JNLP file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pack200 (Default: false)", 2);
                this.append(sb, "Indicates whether or not jar resources should be compressed using pack200. Setting this value to true requires SDK 5.0 or greater.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourcesDirectory", 2);
                this.append(sb, "The location of the directory (relative or absolute) containing non-jar resources that are to be included in the JNLP bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sign", 2);
                this.append(sb, "The Sign Config", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: ${project.basedir}/src/main/jnlp)", 2);
                this.append(sb, "The location where the JNLP Velocity template files are stored.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "unsignAlreadySignedJars (Default: false)", 2);
                this.append(sb, "Define whether to remove existing signatures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose output.", 3);
                this.append(sb, "Expression: ${verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyjar (Default: true)", 2);
                this.append(sb, "Indicates whether or not jar files should be verified after signing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory (Default: ${project.build.directory}/jnlp)", 2);
                this.append(sb, "The directory in which files will be stored prior to processing.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jnlp-single".equals(this.goal)) {
            this.append(sb, "webstart:jnlp-single", 0);
            this.append(sb, "Packages a jnlp application without launching a parallel lifecycle build. Also, this mojo is not an aggregator, so it can be used multiple times in a single multimodule build.\nThe plugin tries to not re-sign\nre-pack if the dependent jar hasn't changed. As a consequence, if one modifies the pom jnlp config or a keystore, one should clean before rebuilding.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attachArchive (Default: true)", 2);
                this.append(sb, "Flag to attach the archive or not to the project's build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUnsign (Default: true)", 2);
                this.append(sb, "To authorize or not to unsign some already signed jar.\nIf set to false and the unsign parameter is set to true then the build will fail if there is a jar to unsign, to avoid this use then the extension jnlp component.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "codebase (Default: ${project.url}/jnlp)", 2);
                this.append(sb, "The code base to use on the generated jnlp files.", 3);
                this.append(sb, "Expression: ${jnlp.codebase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependencies", 2);
                this.append(sb, "[optional] transitive dependencies filter - if omitted, the plugin will include all transitive dependencies. Provided and test scope dependencies are always excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeTransitive", 2);
                this.append(sb, "Set to true to exclude all transitive dependencies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gzip (Default: false)", 2);
                this.append(sb, "Indicates whether or not gzip archives will be created for each of the jar files included in the webstart bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jnlp", 2);
                this.append(sb, "The jnlp configuration element.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jnlpExtensions", 2);
                this.append(sb, "[optional] extensions configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "A placeholder for an obsoleted configuration element.\nThis dummy parameter is here to force the plugin configuration to fail in case one didn't properly migrate from 1.0-alpha-1 to 1.0-alpha-2 configuration.\n\nIt will be removed before 1.0.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "libPath", 2);
                this.append(sb, "The path where the libraries are placed within the jnlp structure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "makeArchive (Default: true)", 2);
                this.append(sb, "Flag to create the archive or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputJarVersions (Default: false)", 2);
                this.append(sb, "When set to true, this flag indicates that a version attribute should be output in each of the jar resource elements in the generated JNLP file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pack200 (Default: false)", 2);
                this.append(sb, "Indicates whether or not jar resources should be compressed using pack200. Setting this value to true requires SDK 5.0 or greater.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourcesDirectory", 2);
                this.append(sb, "The location of the directory (relative or absolute) containing non-jar resources that are to be included in the JNLP bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sign", 2);
                this.append(sb, "The Sign Config", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: ${project.basedir}/src/main/jnlp)", 2);
                this.append(sb, "The location where the JNLP Velocity template files are stored.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "unsignAlreadySignedJars (Default: false)", 2);
                this.append(sb, "Define whether to remove existing signatures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose output.", 3);
                this.append(sb, "Expression: ${verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyjar (Default: true)", 2);
                this.append(sb, "Indicates whether or not jar files should be verified after signing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory (Default: ${project.build.directory}/jnlp)", 2);
                this.append(sb, "The directory in which files will be stored prior to processing.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "webstart:report", 0);
            this.append(sb, "Creates a JNLP report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "codebase (Default: ${project.url}/jnlp)", 2);
                this.append(sb, "The code base to use on the generated jnlp files.", 3);
                this.append(sb, "Expression: ${jnlp.codebase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jnlpSourceDirectory (Default: ${project.build.directory}/jnlp)", 2);
                this.append(sb, "Directory where the jnlp artifacts and jnlp sources files reside.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Location where the site is generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputName (Default: jnlp-report)", 2);
                this.append(sb, "The default filename to use for the report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${outputName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteJnlpDirectory (Default: jnlp)", 2);
                this.append(sb, "Directory in the site directory where the jnlp artifacts and jnlp sources files reside.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${jnlp.siteJnlpDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteJnlpFile (Default: launch.jnlp)", 2);
                this.append(sb, "Name of the main jnlp file of the project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${jnlp.siteJnlpFile}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "unsign".equals(this.goal)) {
            this.append(sb, "webstart:unsign", 0);
            this.append(sb, "Unsigns a JAR, removing signatures.\nThis code will hopefully be moved into the jar plugin when stable enough.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "jarPath (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2);
                this.append(sb, "Path of the jar to unsign. When specified, the finalName is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to true to disable signing. Useful to speed up build process in development environment.", 3);
                this.append(sb, "Expression: ${maven.jar.unsign.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tempDirectory (Default: ${basedir})", 2);
                this.append(sb, "The directory location used for temporary storage of files used by this mojo.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${tempdir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose See options.", 3);
                this.append(sb, "Expression: ${verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

