/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.UseLatestVersionsMojoBase;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.SegmentUtils;

@Mojo(name="use-next-snapshots", threadSafe=true)
public class UseNextSnapshotsMojo
extends UseLatestVersionsMojoBase {
    @Parameter(property="allowMajorUpdates", defaultValue="false")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="false")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;

    @Inject
    public UseNextSnapshotsMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
        this.allowSnapshots = true;
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        try {
            DependencyManagement dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement();
            if (dependencyManagement != null) {
                this.useNextSnapshots(pom, dependencyManagement.getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT);
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useNextSnapshots(pom, this.getProject().getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY);
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useNextSnapshots(pom, Collections.singletonList(this.getParentDependency()), DependencyChangeRecord.ChangeKind.PARENT);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useNextSnapshots(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies, DependencyChangeRecord.ChangeKind changeKind) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog());
        this.useLatestVersions(pom, dependencies, (dep, versions) -> {
            try {
                return Arrays.stream(versions.getNewerVersions(dep.getVersion(), unchangedSegment, true, false)).filter(v -> SNAPSHOT_REGEX.matcher(v.toString()).matches()).findFirst();
            }
            catch (InvalidSegmentException e) {
                this.getLog().info((CharSequence)("Ignoring " + this.toString((Dependency)dep) + " as the version number is too short"));
                return Optional.empty();
            }
        }, changeKind, dep -> !SNAPSHOT_REGEX.matcher(dep.getVersion()).matches());
    }
}

