/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ship;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;

public class LogOutputStream
extends OutputStream {
    private final Log log;
    private final PipedOutputStream pos;
    private final PipedInputStream pis;
    private final Thread logThread;

    public LogOutputStream(Log destination, boolean error) throws IOException {
        this.log = destination;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.logThread = new Thread(new LogRunnable(error));
        this.logThread.setDaemon(true);
        this.logThread.start();
    }

    public void write(int b) throws IOException {
        this.pos.write(b);
    }

    public void close() throws IOException {
        this.pos.close();
        try {
            this.logThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.close();
    }

    private class LogRunnable
    implements Runnable {
        private final Reader reader;
        private final BufferedReader bufferedReader;
        private boolean error;

        private LogRunnable(Reader reader, boolean error) {
            this.reader = reader;
            this.bufferedReader = new BufferedReader(reader);
            this.error = error;
        }

        public LogRunnable(Charset cs, boolean error) {
            this(new InputStreamReader((InputStream)logOutputStream.pis, cs), error);
        }

        public LogRunnable(boolean error) {
            this(new InputStreamReader(logOutputStream.pis), error);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                while (null != (line = this.bufferedReader.readLine())) {
                    if (this.error) {
                        LogOutputStream.this.log.error((CharSequence)line);
                        continue;
                    }
                    LogOutputStream.this.log.info((CharSequence)line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtil.close((Reader)this.bufferedReader);
                IOUtil.close((Reader)this.reader);
                IOUtil.close((InputStream)LogOutputStream.this.pis);
            }
        }
    }
}

