/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.patch;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.patch.AbstractPatchMojo;
import org.codehaus.mojo.tools.project.extras.DerivedArtifact;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class ResolvePatchesMojo
extends AbstractPatchMojo {
    private boolean optimizations;
    private File patchDirectory;
    private File patchArtifactUnpackDirectory;
    private String patchArtifactUnpackSubpath;
    private String patchArtifactClassifier;
    private String patchArtifactType;
    private Artifact projectArtifact;
    private List<ArtifactRepository> remoteRepositories;
    private ArtifactRepository localRepository;
    private ArtifactResolver artifactResolver;
    private ArchiverManager archiverManager;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        boolean useArtifact = this.retrieveAndUnpackPatchArtifact();
        if (useArtifact) {
            File patchDir = this.patchArtifactUnpackDirectory;
            if (this.patchArtifactUnpackSubpath != null && !(patchDir = new File(patchDir, this.patchArtifactUnpackSubpath)).exists()) {
                throw new MojoExecutionException("Sub-path does not exist in unpacked patch-artifact: " + this.patchArtifactUnpackSubpath + " (full path should be: " + patchDir.getAbsolutePath() + ").");
            }
        } else if (this.patchDirectory.exists() && this.patchDirectory.list().length > 0) {
            this.getLog().debug((CharSequence)("Using patches from: " + this.patchDirectory));
        } else {
            throw new MojoExecutionException("Patching configured, but no valid patch artifact or patch directory could be found.");
        }
    }

    private boolean retrieveAndUnpackPatchArtifact() throws MojoExecutionException {
        DefaultArtifactHandler handler = new DefaultArtifactHandler(this.patchArtifactType);
        DerivedArtifact patchArtifact = new DerivedArtifact(this.projectArtifact, this.patchArtifactClassifier, this.patchArtifactType, (ArtifactHandler)handler);
        try {
            this.artifactResolver.resolveAlways((Artifact)patchArtifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve patch-artifact: " + patchArtifact.getId(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)("Could not find patch-artifact: " + patchArtifact), (Throwable)e);
        }
        if (!patchArtifact.isResolved()) {
            return false;
        }
        File patchArtifactFile = patchArtifact.getFile();
        this.getLog().debug((CharSequence)("Unpacking: " + patchArtifactFile));
        UnArchiver unarchiver = null;
        try {
            unarchiver = this.archiverManager.getUnArchiver(patchArtifactFile);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Cannot find un-archiver for patch-archive: " + patchArtifactFile.getAbsolutePath(), (Exception)((Object)e));
        }
        this.patchArtifactUnpackDirectory.mkdirs();
        unarchiver.setSourceFile(patchArtifactFile);
        unarchiver.setDestDirectory(this.patchArtifactUnpackDirectory);
        try {
            unarchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to unpack patch-archive: " + patchArtifactFile.getAbsolutePath(), (Exception)((Object)e));
        }
        return true;
    }
}

