/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.patch;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.patch.AbstractPatchMojo;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ApplyPatchesMojo
extends AbstractPatchMojo {
    private boolean skipApplication;
    private File workDir;
    private File originalFile;
    private File destFile;
    private File patchSourceDir;
    private List<String> patches;
    private File patchFile;
    private int strip = 0;
    private boolean ignoreWhitespace = true;
    private boolean reverse = false;
    private boolean backups = false;
    private CommandLineManager cliManager;

    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skipApplication) {
            this.getLog().info((CharSequence)"Skipping patchfile application (per configuration).");
            return;
        }
        LinkedHashMap<String, Commandline> patchCommandsByFileName = new LinkedHashMap<String, Commandline>();
        if (this.patchFile != null) {
            if (!this.patchFile.exists()) {
                throw new MojoFailureException((Object)this, "Patch operation cannot proceed.", "Cannot find specified patch: '" + this.patchFile.getPath());
            }
            patchCommandsByFileName.put(this.patchFile.getName(), this.createPatchCommand(this.patchFile));
        } else if (this.patches != null) {
            for (String patch : this.patches) {
                File myPatch = new File(this.patchSourceDir, patch);
                if (!myPatch.exists()) {
                    throw new MojoFailureException((Object)this, "Patch operation cannot proceed.", "Cannot find specified patch: '" + patch + "' in patch-source directory: '" + this.patchSourceDir + "'.");
                }
                patchCommandsByFileName.put(patch, this.createPatchCommand(myPatch));
            }
        } else {
            this.getLog().info((CharSequence)"Nothing to do.");
            return;
        }
        StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
        for (Map.Entry entry : patchCommandsByFileName.entrySet()) {
            String patchName = (String)entry.getKey();
            Commandline cli = (Commandline)entry.getValue();
            try {
                int result = this.cliManager.execute(cli, consumer, consumer);
                if (result == 0) continue;
                throw new MojoExecutionException("Patch command failed (exit value != 0). Please see debug output for more information.");
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Failed to apply patch: " + patchName + ". See debug output for more information.", (Exception)((Object)e));
            }
        }
    }

    private Commandline createPatchCommand(File myPatch) {
        Commandline cli = new Commandline();
        cli.setExecutable("patch");
        cli.createArg().setLine("-p" + this.strip);
        if (this.ignoreWhitespace) {
            cli.createArg().setValue("-l");
        }
        if (this.reverse) {
            cli.createArg().setValue("-R");
        }
        if (this.backups) {
            cli.createArg().setValue("-b");
        }
        if (this.originalFile != null) {
            cli.createArg().setValue(this.originalFile.getAbsolutePath());
            if (this.destFile != null) {
                cli.createArg().setLine("-o " + this.destFile.getAbsolutePath());
            }
            cli.createArg().setValue(myPatch.getAbsolutePath());
        } else {
            if (this.workDir != null) {
                cli.setWorkingDirectory(this.workDir.getAbsolutePath());
            } else {
                this.getLog().info((CharSequence)"We'll be patching the project basedir...keep all hands and legs inside the bus, and hold on!");
            }
            cli.createArg().setLine("--input=" + myPatch.getAbsolutePath());
        }
        return cli;
    }
}

