/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.ounce.AbstractOunceMojo;
import org.codehaus.mojo.ounce.core.OunceCore;
import org.codehaus.mojo.ounce.core.OunceCoreException;
import org.codehaus.mojo.ounce.utils.Utils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;

public class ScanMojo
extends AbstractOunceMojo {
    String applicationFile;
    String assessmentName;
    String assessmentOutput;
    String caller;
    String reportType;
    String reportOutputType;
    String reportOutputPath;
    int includeSrcBefore = -1;
    int includeSrcAfter = -1;
    boolean publish;
    String installDir;
    boolean waitForScan;
    protected static Set cache = new HashSet();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isEmpty((String)this.applicationFile)) {
            throw new MojoExecutionException("'applicationFile' must be defined.");
        }
        if (this.shouldExecute()) {
            try {
                if (this.includeSrcAfter != -1 || this.includeSrcBefore != -1) {
                    if (this.options == null) {
                        this.options = new HashMap();
                    }
                    this.options.put("includeSrcAfter", new Integer(this.includeSrcAfter));
                    this.options.put("includeSrcBefore", new Integer(this.includeSrcBefore));
                }
                OunceCore core = this.getCore();
                core.scan(Utils.convertToVariablePath(this.applicationFile, this.pathVariableMap), this.assessmentName, this.assessmentOutput, this.caller, this.reportType, this.reportOutputType, this.reportOutputPath, this.publish, this.options, this.installDir, this.waitForScan, this.getLog());
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Unable to lookup the core interface for hint: " + this.coreHint, (Exception)((Object)e));
            }
            catch (OunceCoreException e) {
                throw new MojoExecutionException("Nested Ouncecore exception: " + e.getLocalizedMessage(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping Scan because these same parameters where already used in a scan for this project during this build. (build was probably forked)");
        }
    }

    protected boolean shouldExecute() {
        return cache.add(this.getParameterHash());
    }

    protected String getParameterHash() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSafeHash(this.applicationFile));
        buf.append("-");
        buf.append(this.getSafeHash(this.assessmentOutput));
        buf.append("-");
        buf.append(this.getSafeHash(this.caller));
        buf.append("-");
        buf.append(this.getSafeHash(this.pathVariableMap));
        buf.append("-");
        buf.append(this.getSafeHash(this.reportOutputPath));
        buf.append("-");
        buf.append(this.getSafeHash(this.reportOutputType));
        buf.append("-");
        buf.append(this.getSafeHash(this.reportType));
        this.getLog().debug((CharSequence)("Parameter Hash: " + buf.toString()));
        return buf.toString();
    }

    private final int getSafeHash(Object o) {
        if (o != null) {
            return o.hashCode();
        }
        return 0;
    }
}

