/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.logging.Log;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.codehaus.mojo.ounce.core.OunceCore;
import org.codehaus.mojo.ounce.core.OunceCoreApplication;
import org.codehaus.mojo.ounce.core.OunceCoreException;
import org.codehaus.mojo.ounce.core.OunceCoreProject;
import org.codehaus.mojo.ounce.core.OunceProjectBean;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OunceCoreXmlSerializer
implements OunceCore {
    public void createApplication(String baseDir, String theName, String applicationRoot, List theProjects, Map options, Log log) throws OunceCoreException {
        Collections.sort(theProjects);
        log.info((CharSequence)"OunceCoreXmlSerializer: Writing Application parameters to xml.");
        try {
            Object xmlDoc;
            Element root = null;
            String filePath = baseDir + File.separator + theName + ".paf";
            File pafFile = new File(filePath);
            if (pafFile.exists()) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                log.info((CharSequence)("Reading paf: '" + filePath + "'..."));
                xmlDoc = builder.parse(pafFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("Application")) continue;
                    root = (Element)node;
                    NodeList applicationChildren = node.getChildNodes();
                    for (int j = 0; j < applicationChildren.getLength(); ++j) {
                        Node child = applicationChildren.item(j);
                        String childName = child.getNodeName();
                        if (!childName.equals("Project")) continue;
                        node.removeChild(child);
                    }
                }
            } else {
                log.info((CharSequence)("Creating new paf: '" + filePath + "'..."));
                xmlDoc = new DocumentImpl();
                root = xmlDoc.createElement("Application");
                root.setAttribute("name", theName);
                xmlDoc.appendChild(root);
            }
            for (int i = 0; i < theProjects.size(); ++i) {
                OunceProjectBean projectBean = (OunceProjectBean)theProjects.get(i);
                String projectPath = projectBean.getPath() + File.separator + projectBean.name + ".ppf";
                Element project = xmlDoc.createElementNS(null, "Project");
                project.setAttributeNS(null, "path", projectPath);
                project.setAttributeNS(null, "language_type", "2");
                root.appendChild(project);
            }
            FileOutputStream fos = new FileOutputStream(filePath);
            OutputFormat of = new OutputFormat("XML", "UTF-8", true);
            of.setIndent(1);
            of.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer((OutputStream)fos, of);
            serializer.asDOMSerializer();
            serializer.serialize(xmlDoc.getDocumentElement());
            fos.close();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    public void createProject(String baseDir, String theName, String projectRoot, List theSourceRoots, String theWebRoot, String theClassPath, String theJdkName, String compilerOptions, String packaging, Map options, Log log) throws OunceCoreException {
        log.info((CharSequence)"OunceCoreXmlSerializer: Writing Project parameters to xml.");
        Properties projectProperties = new Properties();
        projectProperties.setProperty("name", theName);
        projectProperties.setProperty("language_type", "2");
        projectProperties.setProperty("default_configuration_name", "Configuration 1");
        if (options != null) {
            Set keys = options.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)options.get(key);
                projectProperties.setProperty(key, value);
            }
        }
        if (!StringUtils.isEmpty((String)theWebRoot) && !StringUtils.isEmpty((String)packaging) && packaging.equals("war")) {
            projectProperties.setProperty("web_context_root_path", theWebRoot.trim());
        }
        if (!StringUtils.isEmpty((String)compilerOptions)) {
            projectProperties.setProperty("compiler_options", compilerOptions);
        }
        try {
            String name;
            Object xmlDoc;
            Element root = null;
            String filePath = baseDir + File.separator + theName + ".ppf";
            File ppfFile = new File(filePath);
            if (ppfFile.exists()) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                log.info((CharSequence)("Reading ppf: '" + filePath + "'..."));
                xmlDoc = builder.parse(ppfFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    name = node.getNodeName();
                    if (!name.equals("Project")) continue;
                    root = (Element)node;
                    NodeList projectChildren = node.getChildNodes();
                    for (int j = 0; j < projectChildren.getLength(); ++j) {
                        Node child = projectChildren.item(j);
                        String childName = child.getNodeName();
                        if (!childName.equals("Configuration") && !childName.equals("Source")) continue;
                        if (childName.equals("Source")) {
                            NamedNodeMap attribs = child.getAttributes();
                            String webStr = attribs.getNamedItem("web").getNodeValue();
                            if (webStr != null && webStr.equals("true")) continue;
                            node.removeChild(child);
                            continue;
                        }
                        node.removeChild(child);
                    }
                }
            } else {
                log.info((CharSequence)"Creating new Document...");
                xmlDoc = new DocumentImpl();
                root = xmlDoc.createElement("Project");
                xmlDoc.appendChild(root);
            }
            Enumeration<?> propertyNames = projectProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                Object propertyNameObject = propertyNames.nextElement();
                String name2 = (String)propertyNameObject;
                String value = projectProperties.getProperty(name2);
                root.setAttribute(name2, value);
            }
            Properties configProperties = new Properties();
            configProperties.setProperty("name", "Configuration 1");
            configProperties.setProperty("class_path", theClassPath);
            if (theJdkName != null && theJdkName.trim().length() > 0) {
                configProperties.setProperty("jdk_name", theJdkName.trim());
            }
            Element configuration = xmlDoc.createElementNS(null, "Configuration");
            propertyNames = configProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                Object propertyNameObject = propertyNames.nextElement();
                name = (String)propertyNameObject;
                String value = configProperties.getProperty(name);
                configuration.setAttributeNS(null, name, value);
            }
            root.appendChild(configuration);
            for (int i = 0; i < theSourceRoots.size(); ++i) {
                String sourceRoot = (String)theSourceRoots.get(i);
                Element source = xmlDoc.createElementNS(null, "Source");
                source.setAttributeNS(null, "path", "./" + sourceRoot);
                source.setAttributeNS(null, "exclude", "false");
                source.setAttributeNS(null, "web", "false");
                root.appendChild(source);
            }
            FileOutputStream fos = new FileOutputStream(filePath);
            OutputFormat of = new OutputFormat("XML", "UTF-8", true);
            of.setIndent(1);
            of.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer((OutputStream)fos, of);
            serializer.asDOMSerializer();
            serializer.serialize(xmlDoc.getDocumentElement());
            fos.close();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    public OunceCoreApplication readApplication(String path, Log log) throws OunceCoreException {
        block6: {
            try {
                File pafFile = new File(path);
                if (pafFile.exists()) {
                    String parentDir = pafFile.getParent();
                    String applicationName = null;
                    String applicationRoot = null;
                    ArrayList<OunceCoreProject> projects = new ArrayList<OunceCoreProject>();
                    HashMap options = new HashMap();
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    if (log != null) {
                        log.info((CharSequence)("Reading paf: '" + path + "'..."));
                    }
                    Document xmlDoc = builder.parse(pafFile);
                    NodeList nodes = xmlDoc.getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        String name = node.getNodeName();
                        if (!name.equals("Application")) continue;
                        NamedNodeMap applicationAttribs = node.getAttributes();
                        applicationName = applicationAttribs.getNamedItem("name").getNodeValue();
                        NodeList applicationChildren = node.getChildNodes();
                        for (int j = 0; j < applicationChildren.getLength(); ++j) {
                            Node child = applicationChildren.item(j);
                            String childName = child.getNodeName();
                            if (!childName.equals("Project")) continue;
                            String projectPath = parentDir + File.separator + child.getAttributes().getNamedItem("path").getNodeValue();
                            OunceCoreProject project = this.readProject(projectPath, log);
                            projects.add(project);
                        }
                    }
                    OunceCoreApplication application = new OunceCoreApplication(applicationName, applicationRoot, projects, options);
                    return application;
                }
            }
            catch (Exception ex) {
                if (log == null) break block6;
                log.error((Throwable)ex);
            }
        }
        return null;
    }

    public OunceCoreProject readProject(String path, Log log) throws OunceCoreException {
        try {
            File ppfFile = new File(path);
            if (ppfFile.exists()) {
                String projectRoot = ppfFile.getParent();
                String projectName = null;
                String jdkName = null;
                String classPath = null;
                String webRoot = null;
                String optionsStr = null;
                ArrayList<String> sourceRoots = new ArrayList<String>();
                HashMap<String, String> options = new HashMap<String, String>();
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                if (log != null) {
                    log.info((CharSequence)("Reading ppf: '" + path + "'..."));
                }
                Document xmlDoc = builder.parse(ppfFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("Project")) continue;
                    NamedNodeMap projectAttribs = node.getAttributes();
                    for (int j = 0; j < projectAttribs.getLength(); ++j) {
                        Node attribNode = projectAttribs.item(j);
                        String nodeName = attribNode.getNodeName();
                        String nodeValue = attribNode.getNodeValue();
                        if (nodeName.equals("name") || nodeName.equals("web_context_root_path")) continue;
                        options.put(nodeName, nodeValue);
                    }
                    if (projectAttribs.getNamedItem("web_context_root_path") != null) {
                        webRoot = projectAttribs.getNamedItem("web_context_root_path").getNodeValue();
                    }
                    projectName = projectAttribs.getNamedItem("name").getNodeValue();
                    NodeList projectChildren = node.getChildNodes();
                    for (int j = 0; j < projectChildren.getLength(); ++j) {
                        Node child = projectChildren.item(j);
                        String childName = child.getNodeName();
                        NamedNodeMap attribs = child.getAttributes();
                        if (childName.equals("Configuration")) {
                            if (attribs.getNamedItem("jdk_name") != null) {
                                jdkName = attribs.getNamedItem("jdk_name").getNodeValue();
                            }
                            if (attribs.getNamedItem("class_path") != null) {
                                classPath = attribs.getNamedItem("class_path").getNodeValue();
                            }
                            if (attribs.getNamedItem("compiler_options") == null) continue;
                            optionsStr = attribs.getNamedItem("compiler_options").getNodeValue();
                            continue;
                        }
                        if (!childName.equals("Source")) continue;
                        String sourcePath = attribs.getNamedItem("path").getNodeValue();
                        String webStr = attribs.getNamedItem("web").getNodeValue();
                        if (webStr != null && (webStr == null || webStr.equals("true"))) continue;
                        sourceRoots.add(sourcePath);
                    }
                }
                String packaging = null;
                if (webRoot != null) {
                    packaging = "war";
                }
                OunceCoreProject project = new OunceCoreProject(projectName, projectRoot, sourceRoots, webRoot, classPath, jdkName, packaging, optionsStr, options);
                return project;
            }
            throw new OunceCoreException("The file '" + ppfFile.getPath() + "' does not exist.");
        }
        catch (Exception ex) {
            if (log != null) {
                log.error((Throwable)ex);
            }
            return null;
        }
    }

    public void scan(String applicationFile, String assessmentName, String assessmentOutput, String caller, String reportType, String reportOutputType, String reportOutputLocation, boolean publish, Map ounceOptions, String installDir, boolean wait, Log log) throws OunceCoreException {
        String command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
        String existingAssessment = null;
        int includeSrcBefore = -1;
        int includeSrcAfter = -1;
        if (ounceOptions != null) {
            if (ounceOptions.get("existingAssessmentFile") != null) {
                existingAssessment = (String)ounceOptions.get("existingAssessmentFile");
            }
            if (ounceOptions.get("includeSrcBefore") != null) {
                includeSrcBefore = (Integer)ounceOptions.get("includeSrcBefore");
            }
            if (ounceOptions.get("includeSrcAfter") != null) {
                includeSrcAfter = (Integer)ounceOptions.get("includeSrcAfter");
            }
        }
        try {
            if (existingAssessment == null) {
                command = command + " scanapplication";
                if (!StringUtils.isEmpty((String)applicationFile)) {
                    command = command + " -application_file \"" + applicationFile + "\"";
                }
                if (!StringUtils.isEmpty((String)assessmentName)) {
                    command = command + " -name \"" + assessmentName + "\"";
                }
                if (!StringUtils.isEmpty((String)assessmentOutput)) {
                    command = command + " -save \"" + assessmentOutput + "\"";
                }
                if (!StringUtils.isEmpty((String)reportType)) {
                    command = command + " -report \"" + reportType + "\" \"" + reportOutputType + "\" " + "\"" + reportOutputLocation + "\"";
                }
                if (publish) {
                    command = command + " -publish";
                }
            } else {
                command = command + " generatereport -assessment \"" + existingAssessment + "\"";
                if (!StringUtils.isEmpty((String)reportType)) {
                    String[] split = reportType.split("[|]");
                    if (split.length != 3) {
                        throw new OunceCoreException("Invalid report type specification '" + reportType + "'.");
                    }
                    String type = split[0];
                    String format = split[1];
                    String location = split[2];
                    command = command + " -type \"" + type + "\" -output \"" + format + "\" -file \"" + location + "\"";
                }
            }
            if (!StringUtils.isEmpty((String)caller)) {
                command = command + " -caller \"" + caller + "\"";
            }
            if (includeSrcBefore != -1) {
                command = command + " -includeSrcBefore " + includeSrcBefore;
            }
            if (includeSrcAfter != -1) {
                command = command + " -includeSrcAfter " + includeSrcAfter;
            }
            System.out.println(command);
            int requestId = this.executeCommand(command, log);
            System.out.println("requestId: " + requestId);
            if (wait) {
                command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
                command = command + " wait -requestid " + requestId;
                System.out.println(command);
                this.executeCommand(command, log);
            }
        }
        catch (Exception ex) {
            throw new OunceCoreException(ex);
        }
    }

    public void createPathVariables(Map pathVariableMap, String installDir, Log log) throws OunceCoreException {
        String command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
        try {
            command = command + " setvars";
            if (pathVariableMap != null) {
                Set keys = pathVariableMap.keySet();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = (String)pathVariableMap.get(key);
                    command = command + " -" + key + " " + value;
                }
                System.out.println(command);
                this.executeCommand(command, log);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private int executeCommand(String command, Log log) throws IOException, InterruptedException {
        String line;
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = input.readLine()) != null) {
            if (log != null) {
                log.info((CharSequence)("ounceauto: " + line));
                continue;
            }
            System.out.println("ounceauto: " + line);
        }
        input.close();
        return p.waitFor();
    }
}

