/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class RunPlatformAppMojo
extends AbstractMojo {
    protected String brandingToken;
    private File outputDirectory;
    protected File netbeansUserdir;
    protected String additionalArguments;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File exec;
        if (!"nbm-application".equals(this.project.getPackaging())) {
            throw new MojoFailureException("The nbm:run-platform goal shall be used within a NetBeans Application project only ('nbm-application' packaging)");
        }
        this.netbeansUserdir.mkdirs();
        File appbasedir = new File(this.outputDirectory, this.brandingToken);
        if (!appbasedir.exists()) {
            throw new MojoExecutionException("The directory that shall contain built application, doesn't exist (" + appbasedir.getAbsolutePath() + ")\n Please invoke 'mvn install' on the project first");
        }
        boolean windows = Os.isFamily((String)"windows");
        Commandline cmdLine = new Commandline();
        if (windows) {
            exec = new File(appbasedir, "bin" + this.brandingToken + "_w.exe");
            if (!exec.exists()) {
                exec = new File(appbasedir, "bin\\" + this.brandingToken + ".exe");
                cmdLine.addArguments(new String[]{"--console", "suppress"});
            }
        } else {
            exec = new File(appbasedir, "bin/" + this.brandingToken);
        }
        cmdLine.setExecutable(exec.getAbsolutePath());
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--userdir");
            args.add(this.netbeansUserdir.getAbsolutePath());
            args.add("-J-Dnetbeans.logger.console=true");
            args.add("-J-ea");
            args.add("--branding");
            args.add(this.brandingToken);
            if (System.getenv("JAVA_HOME") != null) {
                args.add("--jdkhome");
                args.add(System.getenv("JAVA_HOME"));
            }
            cmdLine.addArguments(args.toArray(new String[0]));
            cmdLine.addArguments(CommandLineUtils.translateCommandline((String)this.additionalArguments));
            this.getLog().info((CharSequence)("Executing: " + cmdLine.toString()));
            StreamConsumer out = new StreamConsumer(){

                public void consumeLine(String line) {
                    RunPlatformAppMojo.this.getLog().info((CharSequence)line);
                }
            };
            CommandLineUtils.executeCommandLine((Commandline)cmdLine, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed executing NetBeans", e);
        }
    }
}

