/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Scm;
import org.codehaus.mojo.license.Eol;
import org.codehaus.mojo.license.download.ProjectLicense;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;
import org.codehaus.mojo.license.extended.ExtendedInfo;
import org.codehaus.mojo.license.extended.InfoFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LicenseSummaryWriter {
    static final String LICENSES_XSD_FILE = "licenses.xsd";
    private static final String LICENSE_FOLDER = "/org/codehaus/mojo/license/";
    static final String LICENSE_PATH = "/org/codehaus/mojo/license/licenses.xsd";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s{2,}");

    public static void writeLicenseSummary(List<ProjectLicenseInfo> dependencies, File outputFile, Charset charset, Eol eol, boolean writeVersions) throws ParserConfigurationException, TransformerException, IOException {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = fact.newDocumentBuilder();
        Document doc = parser.newDocument();
        Element root = doc.createElement("licenseSummary");
        doc.appendChild(root);
        Element dependenciesNode = doc.createElement("dependencies");
        root.appendChild(dependenciesNode);
        for (ProjectLicenseInfo dep : dependencies) {
            dependenciesNode.appendChild(LicenseSummaryWriter.createDependencyNode(doc, dep, writeVersions));
        }
        try (StringWriter sw = new StringWriter();){
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.transform(new DOMSource(doc), new StreamResult(sw));
            String platformEol = Eol.PLATFORM.getEolString();
            String outputString = !platformEol.equals(eol.getEolString()) ? sw.toString().replace(platformEol, eol.getEolString()) : sw.toString();
            Files.write(outputFile.toPath(), outputString.getBytes(charset), new OpenOption[0]);
        }
    }

    public static Node createDependencyNode(Document doc, ProjectLicenseInfo dep, boolean writeVersions) {
        List<String> messages = dep.getDownloaderMessages();
        boolean hasDownloaderMessages = messages != null && !messages.isEmpty();
        Element depNode = doc.createElement("dependency");
        Element groupIdNode = doc.createElement("groupId");
        groupIdNode.appendChild(doc.createTextNode(LicenseSummaryWriter.patternOrText(dep.getGroupId(), hasDownloaderMessages)));
        depNode.appendChild(groupIdNode);
        Element artifactIdNode = doc.createElement("artifactId");
        artifactIdNode.appendChild(doc.createTextNode(LicenseSummaryWriter.patternOrText(dep.getArtifactId(), hasDownloaderMessages)));
        depNode.appendChild(artifactIdNode);
        if (writeVersions) {
            Element versionNode = doc.createElement("version");
            versionNode.appendChild(doc.createTextNode(LicenseSummaryWriter.patternOrText(dep.getVersion(), hasDownloaderMessages)));
            depNode.appendChild(versionNode);
        } else if (hasDownloaderMessages) {
            depNode.appendChild(doc.createComment(" <version>" + dep.getVersion() + "</version> "));
        }
        if (hasDownloaderMessages) {
            Element matchLicensesNode = doc.createElement("matchLicenses");
            if (dep.getLicenses() == null || dep.getLicenses().isEmpty()) {
                matchLicensesNode.appendChild(doc.createComment(" Match dependency with no licenses "));
            } else {
                for (ProjectLicense lic : dep.getLicenses()) {
                    matchLicensesNode.appendChild(LicenseSummaryWriter.createLicenseNode(doc, lic, true));
                }
            }
            depNode.appendChild(matchLicensesNode);
        }
        LicenseSummaryWriter.addExtendedInfo(doc, dep, depNode);
        Element licensesNode = doc.createElement("licenses");
        if (CollectionUtils.isEmpty(dep.getLicenses())) {
            String comment = hasDownloaderMessages ? " Manually add license elements here: " : " No license information available. ";
            licensesNode.appendChild(doc.createComment(comment));
        } else {
            if (hasDownloaderMessages) {
                licensesNode.appendChild(doc.createComment(" Manually fix the existing license nodes: "));
            }
            for (ProjectLicense lic : dep.getLicenses()) {
                licensesNode.appendChild(LicenseSummaryWriter.createLicenseNode(doc, lic, false));
            }
        }
        depNode.appendChild(licensesNode);
        if (hasDownloaderMessages) {
            Element downloaderMessagesNode = doc.createElement("downloaderMessages");
            for (String msg : messages) {
                Element downloaderMessageNode = doc.createElement("downloaderMessage");
                downloaderMessageNode.appendChild(doc.createTextNode(msg));
                downloaderMessagesNode.appendChild(downloaderMessageNode);
            }
            depNode.appendChild(downloaderMessagesNode);
        }
        return depNode;
    }

    private static void addExtendedInfo(Document doc, ProjectLicenseInfo dep, Node depNode) {
        if (dep.getExtendedInfo() != null) {
            ExtendedInfo extendedInfo = dep.getExtendedInfo();
            LicenseSummaryWriter.addTextPropertyIfSet(doc, depNode, "name", extendedInfo.getName());
            LicenseSummaryWriter.addTextPropertyIfSet(doc, depNode, "bundleLicense", extendedInfo.getBundleLicense());
            LicenseSummaryWriter.addCdataIfSet(doc, depNode, "bundleVendor", extendedInfo.getBundleVendor());
            LicenseSummaryWriter.appendChildNodesIfSet(doc, depNode, "developers", extendedInfo.getDevelopers(), (doc1, developer) -> LicenseSummaryWriter.createDeveloperNode(doc, developer));
            LicenseSummaryWriter.addCdataIfSet(doc, depNode, "implementationVendor", extendedInfo.getImplementationVendor());
            LicenseSummaryWriter.addTextPropertyIfSet(doc, depNode, "inceptionYear", extendedInfo.getInceptionYear());
            LicenseSummaryWriter.appendChildNodesIfSet(doc, depNode, "infoFiles", extendedInfo.getInfoFiles(), (doc1, infoFile) -> LicenseSummaryWriter.createInfoFileNode(doc, infoFile));
            if (extendedInfo.getOrganization() != null && (extendedInfo.getOrganization().getName() != null || extendedInfo.getOrganization().getUrl() != null)) {
                Element organizationNode = doc.createElement("organization");
                Organization organization = extendedInfo.getOrganization();
                LicenseSummaryWriter.addTextPropertyIfSet(doc, organizationNode, "name", organization.getName());
                LicenseSummaryWriter.addTextPropertyIfSet(doc, organizationNode, "url", organization.getUrl());
                depNode.appendChild(organizationNode);
            }
            LicenseSummaryWriter.addTextPropertyIfSet(doc, depNode, "scm", Optional.ofNullable(extendedInfo.getScm()).map(Scm::getUrl).orElse(null));
            LicenseSummaryWriter.addTextPropertyIfSet(doc, depNode, "url", extendedInfo.getUrl());
        }
    }

    private static <T> void appendChildNodesIfSet(Document doc, Node parentNode, String elementName, Collection<T> collection, CreateSubNode<T> createSubNode) {
        if (!CollectionUtils.isEmpty(collection)) {
            Element developersNode = doc.createElement(elementName);
            for (T t : collection) {
                developersNode.appendChild(createSubNode.createSubNode(doc, t));
            }
            parentNode.appendChild(developersNode);
        }
    }

    public static Node createLicenseNode(Document doc, ProjectLicense lic, boolean isMatcher) {
        Element licenseNode = doc.createElement("license");
        if (lic.getName() != null) {
            Element licNameNode = doc.createElement("name");
            licNameNode.appendChild(doc.createTextNode(LicenseSummaryWriter.patternOrText(lic.getName(), isMatcher)));
            licenseNode.appendChild(licNameNode);
        }
        if (lic.getUrl() != null) {
            Element licUrlNode = doc.createElement("url");
            licUrlNode.appendChild(doc.createTextNode(LicenseSummaryWriter.patternOrText(lic.getUrl(), isMatcher)));
            licenseNode.appendChild(licUrlNode);
        }
        if (lic.getDistribution() != null) {
            Element licDistNode = doc.createElement("distribution");
            licDistNode.appendChild(doc.createTextNode(LicenseSummaryWriter.patternOrText(lic.getDistribution(), isMatcher)));
            licenseNode.appendChild(licDistNode);
        }
        if (lic.getFile() != null) {
            Element licFileNode = doc.createElement("file");
            licFileNode.appendChild(doc.createTextNode(LicenseSummaryWriter.patternOrText(lic.getFile(), isMatcher)));
            licenseNode.appendChild(licFileNode);
        }
        if (lic.getComments() != null) {
            Element licCommentsNode = doc.createElement("comments");
            licCommentsNode.appendChild(doc.createTextNode(LicenseSummaryWriter.patternOrText(lic.getComments(), isMatcher)));
            licenseNode.appendChild(licCommentsNode);
        }
        return licenseNode;
    }

    private static Node createDeveloperNode(Document doc, Developer developer) {
        Element developerNode = doc.createElement("developer");
        LicenseSummaryWriter.addTextPropertyIfSet(doc, developerNode, "id", developer.getId());
        LicenseSummaryWriter.addTextPropertyIfSet(doc, developerNode, "email", developer.getEmail());
        LicenseSummaryWriter.addTextPropertyIfSet(doc, developerNode, "name", developer.getName());
        LicenseSummaryWriter.addTextPropertyIfSet(doc, developerNode, "organization", developer.getOrganization());
        LicenseSummaryWriter.addTextPropertyIfSet(doc, developerNode, "organizationUrl", developer.getOrganizationUrl());
        LicenseSummaryWriter.addTextPropertyIfSet(doc, developerNode, "url", developer.getUrl());
        LicenseSummaryWriter.addTextPropertyIfSet(doc, developerNode, "timezone", developer.getTimezone());
        return developerNode;
    }

    private static Node createInfoFileNode(Document doc, InfoFile infoFile) {
        Element infoFileNode = doc.createElement("infoFile");
        LicenseSummaryWriter.addCdataIfSet(doc, infoFileNode, "content", infoFile.getContent());
        LicenseSummaryWriter.appendChildNodesIfSet(doc, infoFileNode, "extractedCopyrightLines", infoFile.getExtractedCopyrightLines(), (doc1, line) -> {
            Element devNameNode = doc.createElement("line");
            devNameNode.appendChild(doc.createCDATASection((String)line));
            return devNameNode;
        });
        LicenseSummaryWriter.addCdataIfSet(doc, infoFileNode, "fileName", infoFile.getFileName());
        LicenseSummaryWriter.addTextPropertyIfSet(doc, infoFileNode, "type", infoFile.getType().toString());
        return infoFileNode;
    }

    private static void addTextPropertyIfSet(Document doc, Node parentNode, String elementName, String property) {
        LicenseSummaryWriter.addPropertyIfSet(doc, parentNode, elementName, property, () -> doc.createTextNode(property));
    }

    private static void addCdataIfSet(Document doc, Node parentNode, String elementName, String property) {
        LicenseSummaryWriter.addPropertyIfSet(doc, parentNode, elementName, property, () -> doc.createCDATASection(LicenseSummaryWriter.prepareCdata(property)));
    }

    private static String prepareCdata(String property) {
        return property.replace("\r\n", "\n").replace("\f", "\n");
    }

    private static void addPropertyIfSet(Document doc, Node parentNode, String elementName, String property, Supplier<Node> nodeSupplier) {
        if (property != null) {
            Element devNameNode = doc.createElement(elementName);
            devNameNode.appendChild(nodeSupplier.get());
            parentNode.appendChild(devNameNode);
        }
    }

    static String patternOrText(String value, boolean isMatcher) {
        if (value != null && !value.isEmpty() && isMatcher) {
            StringBuilder result = new StringBuilder();
            Matcher m = WHITESPACE_PATTERN.matcher(value);
            int offset = 0;
            while (m.find()) {
                if (m.start() > offset) {
                    result.append(Pattern.quote(value.substring(offset, m.start())));
                }
                result.append("\\s+");
                offset = m.end();
            }
            if (offset < value.length()) {
                result.append(Pattern.quote(value.substring(offset)));
            }
            return result.toString();
        }
        return value;
    }

    static interface CreateSubNode<T> {
        public Node createSubNode(Document var1, T var2);
    }
}

