/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.license.AbstractLicensesXmlMojo;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.download.LicenseSummaryReader;
import org.codehaus.mojo.license.download.LicensedArtifact;
import org.codehaus.mojo.license.download.LicensedArtifactResolver;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="licenses-xml-insert-versions", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class LicensesXmlInsertVersionsMojo
extends AbstractLicensesXmlMojo {
    private static final Logger LOG = LoggerFactory.getLogger(LicensesXmlInsertVersionsMojo.class);
    @Parameter(property="license.licensesInputFile")
    protected File licensesInputFile;
    @Parameter(property="license.skipDownloadLicenses", defaultValue="false")
    private boolean skipDownloadLicenses;

    @Inject
    public LicensesXmlInsertVersionsMojo(LicensedArtifactResolver licensedArtifactResolver) {
        super(licensedArtifactResolver);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipDownloadLicenses) {
            LOG.info("Skipping due to skipDownloadLicenses = true");
            return;
        }
        if (this.licensesInputFile == null) {
            this.licensesInputFile = this.licensesOutputFile;
        }
        try {
            Files.createDirectories(this.licensesOutputFile.getParentFile().toPath(), new FileAttribute[0]);
            List<ProjectLicenseInfo> projectLicenseInfos = LicenseSummaryReader.parseLicenseSummary(this.licensesInputFile);
            if (projectLicenseInfos.isEmpty() && this.licensesInputFile.equals(this.licensesOutputFile)) {
                LOG.info("Nothing to do. The licensesInputFile \"{}\" is either empty or does not exist.", (Object)this.licensesInputFile);
                return;
            }
            ArtifactFilters.Builder artifactFiltersBuilder = ArtifactFilters.buidler();
            for (ProjectLicenseInfo dep : projectLicenseInfos) {
                artifactFiltersBuilder.includeGa("\\Q" + dep.getGroupId() + ":" + dep.getArtifactId() + "\\E");
            }
            final ArtifactFilters artifactFilters = artifactFiltersBuilder.build();
            MavenProjectDependenciesConfigurator config = new MavenProjectDependenciesConfigurator(){

                @Override
                public boolean isVerbose() {
                    return LicensesXmlInsertVersionsMojo.this.getLog().isDebugEnabled();
                }

                @Override
                public boolean isIncludeTransitiveDependencies() {
                    return true;
                }

                @Override
                public boolean isExcludeTransitiveDependencies() {
                    return false;
                }

                @Override
                public ArtifactFilters getArtifactFilters() {
                    return artifactFilters;
                }
            };
            TreeMap<String, LicensedArtifact> resolvedDeps = new TreeMap<String, LicensedArtifact>();
            this.licensedArtifactResolver.loadProjectDependencies(new ResolvedProjectDependencies(this.project.getArtifacts(), MojoHelper.getDependencyArtifacts(this.project)), config, this.remoteRepositories, resolvedDeps, false, null);
            HashMap<String, LicensedArtifact> resolvedDepsMap = new HashMap<String, LicensedArtifact>(resolvedDeps.size());
            for (LicensedArtifact dep : resolvedDeps.values()) {
                resolvedDepsMap.put(dep.getGroupId() + ":" + dep.getArtifactId(), dep);
            }
            for (ProjectLicenseInfo dependencyLicenseInfo : projectLicenseInfos) {
                LOG.debug("Checking licenses for project {}", (Object)dependencyLicenseInfo);
                String id = dependencyLicenseInfo.getId();
                LicensedArtifact dependency = (LicensedArtifact)resolvedDepsMap.get(id);
                if (dependency == null) {
                    throw new MojoFailureException("Could not resolve version of " + id + " in file " + this.licensesOutputFile);
                }
                dependencyLicenseInfo.setVersion(dependency.getVersion());
            }
            this.writeLicenseSummary(projectLicenseInfos, this.licensesOutputFile, true);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to write license summary file: " + this.licensesOutputFile, e);
        }
    }

    @Override
    protected Path[] getAutodetectEolFiles() {
        return new Path[]{this.licensesInputFile.toPath(), this.licensesOutputFile.toPath()};
    }
}

