/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jsimport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jsimport.AbstractImportMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileDependencyPersistanceUtil {
    private static final String FILE_DEPENDENCY_GRAPH_NAME = "FileDependency.avro";
    private static final String FILE_DEPENDENCY_GRAPH_SCHEMA_NAME = "FileDependency.avpr";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readFileDependencyGraph(File workFolder, Map<String, LinkedHashSet<String>> fileDependencies, Map<String, String> fileAssignedGlobals) throws MojoExecutionException {
        long lastModified;
        try {
            GenericDatumReader genericDatumReader = new GenericDatumReader();
            File file = new File(workFolder, FILE_DEPENDENCY_GRAPH_NAME);
            DataFileReader dataFileReader = new DataFileReader(file, (DatumReader)genericDatumReader);
            try {
                GenericRecord genericRecord = null;
                while (dataFileReader.hasNext()) {
                    GenericData.Array recordAssignedVarsObjects;
                    genericRecord = (GenericRecord)dataFileReader.next(genericRecord);
                    String recordFile = ((Utf8)genericRecord.get("file")).toString();
                    GenericData.Array recordImportObjects = (GenericData.Array)genericRecord.get("imports");
                    if (recordImportObjects != null) {
                        LinkedHashSet<String> imports = new LinkedHashSet<String>();
                        for (Object recordImportObject : recordImportObjects) {
                            imports.add(((Utf8)recordImportObject).toString());
                        }
                        fileDependencies.put(recordFile, imports);
                    }
                    if ((recordAssignedVarsObjects = (GenericData.Array)genericRecord.get("assignedVars")) == null) continue;
                    for (Object recordAssignedVarsObject : recordAssignedVarsObjects) {
                        fileAssignedGlobals.put(((Utf8)recordAssignedVarsObject).toString(), recordFile);
                    }
                }
            }
            finally {
                dataFileReader.close();
            }
            lastModified = file.lastModified();
        }
        catch (FileNotFoundException e) {
            lastModified = 0L;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem reading file dependency graph.", (Exception)e);
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileDependencyGraph(File workFolder, Map<String, LinkedHashSet<String>> fileDependencies, Map<String, String> fileAssignedGlobals) throws MojoExecutionException {
        try {
            Schema fileDependencySchema;
            workFolder.mkdirs();
            InputStream fileDependencySchemaIs = AbstractImportMojo.class.getResourceAsStream(FILE_DEPENDENCY_GRAPH_SCHEMA_NAME);
            try {
                fileDependencySchema = Schema.parse((InputStream)fileDependencySchemaIs);
            }
            finally {
                fileDependencySchemaIs.close();
            }
            GenericDatumWriter genericDatumWriter = new GenericDatumWriter(fileDependencySchema);
            DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)genericDatumWriter);
            try {
                Set assignedVars;
                dataFileWriter.create(fileDependencySchema, new File(workFolder, FILE_DEPENDENCY_GRAPH_NAME));
                HashSet<String> files = new HashSet<String>(fileDependencies.size() + fileAssignedGlobals.size());
                files.addAll(fileDependencies.keySet());
                HashMap<String, HashSet<String>> fileAssignedGlobalsByFile = new HashMap<String, HashSet<String>>(fileAssignedGlobals.size());
                for (Map.Entry<String, String> entry : fileAssignedGlobals.entrySet()) {
                    String assignedVar = entry.getKey();
                    String file = entry.getValue();
                    assignedVars = (HashSet<String>)fileAssignedGlobalsByFile.get(file);
                    if (assignedVars == null) {
                        assignedVars = new HashSet<String>();
                        fileAssignedGlobalsByFile.put(file, (HashSet<String>)assignedVars);
                    }
                    assignedVars.add(assignedVar);
                }
                files.addAll(fileAssignedGlobalsByFile.keySet());
                for (String file : files) {
                    GenericData.Record genericRecord = new GenericData.Record(fileDependencySchema);
                    LinkedHashSet<String> imports = fileDependencies.get(file);
                    if (imports != null) {
                        GenericData.Array genericArray = new GenericData.Array(imports.size(), Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)));
                        for (String importFile : imports) {
                            genericArray.add((Object)new Utf8(importFile));
                        }
                        genericRecord.put("imports", (Object)genericArray);
                    }
                    if ((assignedVars = (Set)fileAssignedGlobalsByFile.get(file)) != null) {
                        GenericData.Array genericArray = new GenericData.Array(assignedVars.size(), Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)));
                        for (String assignedVar : assignedVars) {
                            genericArray.add((Object)new Utf8(assignedVar));
                        }
                        genericRecord.put("assignedVars", (Object)genericArray);
                    }
                    genericRecord.put("file", (Object)new Utf8(file));
                    dataFileWriter.append((Object)genericRecord);
                }
                dataFileWriter.flush();
            }
            finally {
                dataFileWriter.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem writing file dependency graph.", (Exception)e);
        }
    }

    private FileDependencyPersistanceUtil() {
    }
}

