/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jasperreports;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:jasperreports-maven-plugin:1.0-beta-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven JasperReports Plugin", 0);
        this.append(sb, "Compile Jasper report design file", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile-reports".equals(this.goal)) {
            this.append(sb, "jasperreports:compile-reports", 0);
            this.append(sb, "Compiles JasperReports xml definition files.\nMuch of this was inspired by the JRAntCompileTask, while trying to make it slightly cleaner and easier to use with Maven's mojo api.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalClasspath", 2);
                this.append(sb, "Any additional classpath entry you might want to add to the JasperReports compiler. Not recommended for general use, plugin dependencies should be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalProperties", 2);
                this.append(sb, "Additional JRProperties", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathElements", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "compiler (Default: net.sf.jasperreports.engine.design.JRJavacCompiler)", 2);
                this.append(sb, "Uses the Javac compiler by default. This is different from the original JasperReports ant task, which uses the JDT compiler by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaDirectory", 2);
                this.append(sb, "This is where the generated java sources are stored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepJava (Default: false)", 2);
                this.append(sb, "Deprecated. There seems to be an issue with the compiler plugin so don't expect this to work yet - the dependencies will have disappeared.", 3);
                this.append(sb, "", 0);
                this.append(sb, "Since the JasperReports compiler deletes the compiled classes, one might want to set this to true, if they want to handle the generated java source in their application. Mind that this will not work if the mojo is bound to the compile or any other later phase. (As one might need to do if they use classes from their project in their report design)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepSerializedObject (Default: true)", 2);
                this.append(sb, "Deprecated. Not implemented", 3);
                this.append(sb, "", 0);
                this.append(sb, "Not used for now - just a TODO - the idea being that one might want to set this to false if they want to handle the generated java source in their application.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is where the .jasper files are written.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileExt (Default: .jasper)", 2);
                this.append(sb, "The extension of the compiled report files. Creates files with a .jasper extension by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: src/main/jasperreports)", 2);
                this.append(sb, "This is where the xml report design files should be.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceFileExt (Default: .jrxml)", 2);
                this.append(sb, "The extension of the source files to look for. Finds files with a .jrxml extension by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlValidation (Default: true)", 2);
                this.append(sb, "Wether the xml design files must be validated.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jasperreports:help", 0);
            this.append(sb, "Display help information on jasperreports-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jasperreports:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

