/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:hibernate3-maven-plugin:3.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Hibernate3 Maven Plugin", 0);
        this.append(sb, "Hibernate Tools is a toolset for Hibernate 3 and related projects. The tools provide Maven plugins for performing reverse engineering, code generation and interaction with Hibernate.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 12 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2cfgxml".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2cfgxml", 0);
            this.append(sb, "'hbm2cfgxml' generates a hibernate.cfg.xml. Intended to be used together with a 'jdbcconfiguration' when performing reverse engineering, but can be used with any kind of configuration. The 'hbm2cfgxml' will contain the properties used and adds mapping entries for each mapped class.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2dao".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2dao", 0);
            this.append(sb, "'hbm2dao' generates a set of DAOs.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2ddl".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2ddl", 0);
            this.append(sb, "'hbm2ddl' lets you run schemaexport and schemaupdate which generates the appropriate SQL DDL and allow you to store the result in a file or export it directly to the database. Remember that if a custom naming strategy is needed it is placed on the configuration element.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2doc".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2doc", 0);
            this.append(sb, "'hbm2doc' generates html documentation a'la javadoc for the database schema.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2hbmxml".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2hbmxml", 0);
            this.append(sb, "'hbm2hbmxml' generates a set of .hbm files. Intended to be used together with a 'jdbcconfiguration' when performing reverse engineering, but can be used with any kind of configuration. e.g. to convert from annotation based pojo's to hbm.xml.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbm2java".equals(this.goal)) {
            this.append(sb, "hibernate3:hbm2java", 0);
            this.append(sb, "'hbm2java' is a java code generator. Options for controlling wether JDK 5 syntax can be used and wether the POJO should be annotated with EJB3/Hibernate Annotations.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbmlint".equals(this.goal)) {
            this.append(sb, "hibernate3:hbmlint", 0);
            this.append(sb, "'hbmlint' scans mappings for errors.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hbmtemplate".equals(this.goal)) {
            this.append(sb, "hibernate3:hbmtemplate", 0);
            this.append(sb, "'hbmtemplate' generic exporter that can be controlled by a user provided template or class.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "hibernate3:help", 0);
            this.append(sb, "Display help information on hibernate3-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0hibernate3:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "instrument".equals(this.goal)) {
            this.append(sb, "hibernate3:instrument", 0);
            this.append(sb, "Goal for 'cglib' or 'javassist' instrumentation.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "instrument", 2);
                this.append(sb, "The 'instrument' element containing the plugin configuration.", 3);
                this.append(sb, "Expression: ${instrument}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "query".equals(this.goal)) {
            this.append(sb, "hibernate3:query", 0);
            this.append(sb, "'query' is used to execute a HQL query statements and optionally send the output to a file. Can be used for verifying the mappings and for basic data extraction.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "hibernate3:run", 0);
            this.append(sb, "'AntRun' wrapper.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classRealm", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.classRealm}", 3);
                this.append(sb, "", 0);
                this.append(sb, "hibernatetool", 2);
                this.append(sb, "The 'hibernatetool' element containing the plugin configuration.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${hibernatetool}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

