/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.fitnesse.Fitnesse;
import org.codehaus.mojo.fitnesse.FitnesseAbstractMojo;
import org.codehaus.mojo.fitnesse.FitnessePage;
import org.codehaus.mojo.fitnesse.FitnesseReportMojo;
import org.codehaus.mojo.fitnesse.log.FileConsumer;
import org.codehaus.mojo.fitnesse.log.FitnesseStreamConsumer;
import org.codehaus.mojo.fitnesse.log.LogConsumer;
import org.codehaus.mojo.fitnesse.log.MultipleConsumer;
import org.codehaus.mojo.fitnesse.plexus.FCommandLineException;
import org.codehaus.mojo.fitnesse.plexus.FCommandLineUtils;
import org.codehaus.mojo.fitnesse.plexus.FCommandline;
import org.codehaus.mojo.fitnesse.runner.ClassPathBuilder;

public class FitnesseRunnerMojo
extends FitnesseAbstractMojo {
    private String classPathProvider;
    private ArtifactMetadataSource metadataSource;
    private List remoteRepositories;
    private MavenProject project;
    boolean copyDependencies;
    private List pluginArtifacts;
    private List dependencies;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private String pluginArtifactId;
    private String pluginGroupId;
    private String pluginVersion;
    private String jdk;
    private String jdkOpts;
    private boolean displayOutput;
    private boolean debug;
    private String fitnesseRunnerClass;
    private List classPathSubstitutions = new ArrayList();
    private FCommandline mCmd = new FCommandline();
    private Artifact pluginArtifact;

    public void execute() throws MojoExecutionException, MojoFailureException {
        new File(this.workingDir).mkdirs();
        this.checkConfiguration();
        try {
            FitnesseReportMojo.copyAllResources(new File(this.workingDir), this.getLog(), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Unable to copy resources", e.getCause());
        }
        this.getLog().info((CharSequence)("Found " + this.getFitnesseSize() + " Fitnesse configuration."));
        for (int i = 0; i < this.getFitnesseSize(); ++i) {
            Fitnesse tServer = this.getFitnesse(i);
            this.callFitnesse(tServer);
            this.transformResultPage(tServer);
        }
    }

    void transformResultPage(Fitnesse pServer) throws MojoExecutionException {
        FileInputStream tIn = null;
        try {
            String tSrcFile = this.getTmpFileName(pServer);
            tIn = new FileInputStream(tSrcFile);
            File tDestFile = new File(this.getFinalFileName(pServer));
            if (tDestFile.exists()) {
                tDestFile.delete();
            }
            FileWriter tWriter = new FileWriter(tDestFile);
            FitnessePage tResult = new FitnessePage(new File(tSrcFile));
            this.transformHtml(tIn, tWriter, this.getOutputUrl(pServer), tResult.getStatus());
            tIn.close();
            tIn = null;
            if (!new File(tSrcFile).delete()) {
                this.getLog().error((CharSequence)("Unable to delete tmp file [" + tSrcFile + "]"));
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to tranform html", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to tranform html", (Exception)e);
        }
        finally {
            if (tIn != null) {
                try {
                    tIn.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to close tmp file stream", (Exception)e);
                }
            }
        }
    }

    private String getClassPath(Fitnesse tServer) throws MojoExecutionException {
        String tResult;
        if ("fitnesse".equals(this.classPathProvider)) {
            StringBuffer tBuffer = new StringBuffer();
            ClassPathBuilder tBuilder = new ClassPathBuilder(tServer.getHostName(), tServer.getPort(), tServer.getPageName(), this.getLog());
            tBuffer.append(tBuilder.getPath(this.classPathSubstitutions, this.getLog()));
            Iterator tIt = this.pluginArtifacts.iterator();
            while (tIt.hasNext()) {
                Artifact curArt = (Artifact)tIt.next();
                if (curArt.getScope().equals("provided") || curArt.getScope().equals("test")) continue;
                tBuffer.append(File.pathSeparatorChar).append(curArt.getFile().getAbsolutePath());
            }
            tBuffer.append(File.pathSeparatorChar).append(this.resolvePlugin().getFile().getAbsolutePath());
            this.getLog().info((CharSequence)"Try to download classpath from FitNesse server...");
            tResult = tBuffer.toString();
        } else {
            tResult = this.getMavenClassPath();
        }
        if (this.copyDependencies) {
            tResult = this.copyDependenciesLocally(tResult);
        }
        return tResult;
    }

    String copyDependenciesLocally(String pClasspath) throws MojoExecutionException {
        String tPathSep = System.getProperty("path.separator");
        String tFileSep = System.getProperty("file.separator");
        File tFolder = new File(this.workingDir + tFileSep + "lib");
        if (!tFolder.exists()) {
            tFolder.mkdirs();
        }
        StringTokenizer tToken = new StringTokenizer(pClasspath, tPathSep);
        StringBuffer tBuffer = new StringBuffer();
        try {
            while (tToken.hasMoreTokens()) {
                String tFileName = tToken.nextToken();
                File tFile = new File(tFileName);
                if (tFile.exists()) {
                    FileInputStream tFileInput = new FileInputStream(tFile);
                    int tIndex = tFileName.lastIndexOf(tFileSep);
                    String tShortFileName = tFileName.substring(tIndex + 1);
                    File tResultFile = new File(this.workingDir + tFileSep + "lib" + tFileSep + tShortFileName);
                    FitnesseReportMojo.copyFile(this.getLog(), tFileInput, tResultFile);
                    tBuffer.append("lib" + tFileSep + tShortFileName + tPathSep);
                    continue;
                }
                this.getLog().warn((CharSequence)("Unable to find the file [" + tFileName + "], skipping this file"));
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File not found", (Exception)e);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("File not found", (Exception)((Object)e));
        }
        return tBuffer.toString();
    }

    String getMavenClassPath() throws MojoExecutionException {
        this.getLog().error((CharSequence)"PKE MavenClassPath");
        StringBuffer tBuffer = new StringBuffer();
        Set tArtifacts = this.transitivelyResolvePomDependencies();
        if (tArtifacts != null && !tArtifacts.isEmpty()) {
            Iterator it = tArtifacts.iterator();
            while (it.hasNext()) {
                Artifact curArtififact = (Artifact)it.next();
                tBuffer.append(curArtififact.getFile().getAbsolutePath()).append(File.pathSeparatorChar);
            }
        }
        tBuffer.append(this.project.getBuild().getOutputDirectory()).append(File.pathSeparatorChar);
        tBuffer.append(this.project.getBuild().getTestOutputDirectory()).append(File.pathSeparatorChar);
        this.getLog().error((CharSequence)("PKE " + tBuffer));
        return tBuffer.toString();
    }

    public Set transitivelyResolvePomDependencies() throws MojoExecutionException {
        ArtifactResolutionResult result;
        Set dependencyArtifacts;
        try {
            dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)this.dependencies, null, null, null);
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Invalid dependency", (Exception)((Object)e));
        }
        dependencyArtifacts.add(this.project.getArtifact());
        List listeners = Collections.EMPTY_LIST;
        try {
            result = this.artifactResolver.resolveTransitively(dependencyArtifacts, this.project.getArtifact(), Collections.EMPTY_MAP, this.localRepository, this.remoteRepositories, this.metadataSource, null, listeners);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve Artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to resolve Artifact.", (Exception)((Object)e));
        }
        return result.getArtifacts();
    }

    void callFitnesse(Fitnesse pServer) throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)("Call result of the server," + pServer));
        FCommandline tCmd = this.prepareCommandLine(pServer, this.getClassPath(pServer));
        this.executeCommand(pServer, tCmd);
    }

    void executeCommand(Fitnesse pServer, FCommandline pCmd) throws MojoFailureException, MojoExecutionException {
        int tResult;
        FitnesseStreamConsumer tInfoConsumer = null;
        try {
            tInfoConsumer = this.getStandardConsumer(pServer);
            tResult = FCommandLineUtils.executeCommandLine(pCmd, tInfoConsumer, this.getErrorConsumer(tInfoConsumer));
        }
        catch (FCommandLineException e) {
            this.getLog().error((CharSequence)("Unable to start fitnesse [" + pCmd.toString() + "]"), (Throwable)e);
            throw new MojoExecutionException("Unable to start fitnesse [" + pCmd.toString() + "]", (Exception)e);
        }
        finally {
            if (tInfoConsumer != null) {
                this.closeConsumer(tInfoConsumer);
            }
        }
        if (tResult != 0) {
            if (tInfoConsumer.hasGeneratedResultFile()) {
                if (this.isFailOnError()) {
                    throw new MojoFailureException("Fitnesse command ended with errors, exit code:" + tResult);
                }
                this.getLog().info((CharSequence)("Fitnesse command ended with errors, exit code:" + tResult + ", but failOnError is configure to \"false\"" + " change your configuration if you want to fail your build"));
            } else {
                throw new MojoExecutionException("Unable to run Fitnesse, exit code [" + tResult + "]");
            }
        }
        this.getLog().info((CharSequence)("Fitnesse invocation ended with result code [" + tResult + "]"));
    }

    private void closeConsumer(FitnesseStreamConsumer pInfoConsumer) {
        if (pInfoConsumer instanceof MultipleConsumer) {
            ((MultipleConsumer)pInfoConsumer).getFileConsumer().close();
        } else {
            ((FileConsumer)pInfoConsumer).close();
        }
    }

    FitnesseStreamConsumer getErrorConsumer(FitnesseStreamConsumer pConsumer) {
        if (this.displayOutput) {
            MultipleConsumer tMultiConsumer = (MultipleConsumer)pConsumer;
            return new MultipleConsumer(new LogConsumer(this.getLog(), Level.SEVERE), tMultiConsumer.getFileConsumer());
        }
        return (FileConsumer)pConsumer;
    }

    FitnesseStreamConsumer getStandardConsumer(Fitnesse pServer) {
        File tOutputFile = new File(this.getOutputFileName(pServer));
        if (tOutputFile.exists()) {
            tOutputFile.delete();
        }
        FileConsumer tFileConsumer = new FileConsumer(tOutputFile);
        if (this.displayOutput) {
            return new MultipleConsumer(new LogConsumer(this.getLog(), Level.INFO), tFileConsumer);
        }
        return tFileConsumer;
    }

    void checkConfiguration() throws MojoExecutionException {
        super.checkConfiguration();
        try {
            Class<?> tClass = Class.forName(this.fitnesseRunnerClass);
            tClass.getMethod("main", String;.class);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("The class [" + this.fitnesseRunnerClass + "] could not be found, check your maven-fitnesse-plugin configuration and the plugin documentation.");
        }
        catch (SecurityException e) {
            throw new MojoExecutionException("The class [" + this.fitnesseRunnerClass + "] doesn't have a \"main\" accessible method.", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("The class [" + this.fitnesseRunnerClass + "] doesn't have a \"main\" accessible method.", (Exception)e);
        }
        if (!"fitnesse".equals(this.classPathProvider) && !"maven".equals(this.classPathProvider)) {
            throw new MojoExecutionException("classPathProvider accepts only \"fitnesse\" ou \"maven\" values. [" + this.classPathProvider + "] is not valid.");
        }
    }

    FCommandline prepareCommandLine(Fitnesse pServer, String pClassPath) {
        this.mCmd.clear();
        this.mCmd.setExecutable(this.jdk);
        if (this.jdkOpts != null && this.jdkOpts.length() > 0) {
            StringTokenizer tTok = new StringTokenizer(this.jdkOpts, " ");
            while (tTok.hasMoreTokens()) {
                this.mCmd.createArgument().setValue(tTok.nextToken());
            }
        }
        this.mCmd.createArgument().setValue("-cp");
        this.mCmd.createArgument().setValue(pClassPath);
        this.mCmd.createArgument().setValue(this.fitnesseRunnerClass);
        this.mCmd.createArgument().setValue("-v");
        if (this.debug) {
            this.mCmd.createArgument().setValue("-debug");
        }
        this.mCmd.createArgument().setValue("-html");
        String tFileName = this.getTmpFileName(pServer);
        File tFile = new File(tFileName);
        if (tFile.exists()) {
            tFile.delete();
        }
        this.mCmd.createArgument().setValue(tFileName);
        this.mCmd.createArgument().setValue("-nopath");
        this.mCmd.createArgument().setValue(pServer.getHostName());
        this.mCmd.createArgument().setValue("" + pServer.getPort());
        this.mCmd.createArgument().setValue(pServer.getPageName());
        this.mCmd.setWorkingDirectory(this.workingDir);
        this.getLog().info((CharSequence)("Execute =" + this.mCmd.toString()));
        this.getLog().info((CharSequence)("From =" + this.mCmd.getWorkingDirectory()));
        return this.mCmd;
    }

    public void setFitnesseRunnerClass(String pFitnesseRunnerClass) {
        this.fitnesseRunnerClass = pFitnesseRunnerClass;
    }

    public void setJdk(String pJdk) {
        this.jdk = pJdk;
    }

    public void setWorkingDir(String pWorkingDir) {
        this.workingDir = pWorkingDir;
    }

    void setDebug(boolean pDebug) {
        this.debug = pDebug;
    }

    void setCmd(FCommandline pCmd) {
        this.mCmd = pCmd;
    }

    void setJdkOpts(String jdkOpts) {
        this.jdkOpts = jdkOpts;
    }

    public void setPluginArtifacts(List pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    public Artifact resolvePlugin() throws MojoExecutionException {
        if (this.pluginArtifact == null) {
            Artifact tPluginArtifact = this.artifactFactory.createArtifactWithClassifier(this.pluginGroupId, this.pluginArtifactId, this.pluginVersion, "maven-plugin", "");
            try {
                this.artifactResolver.resolve(tPluginArtifact, new ArrayList(), this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Unable to resolve artificat", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Unable to resolve artificat", (Exception)((Object)e));
            }
            return tPluginArtifact;
        }
        return this.pluginArtifact;
    }

    void setPluginArtifactInfo(String pGroupId, String pArtifactId, String pVersion) {
        this.pluginGroupId = pGroupId;
        this.pluginArtifactId = pArtifactId;
        this.pluginVersion = pVersion;
    }

    public void setPluginArtifact(Artifact pArtifact) {
        this.pluginArtifact = pArtifact;
    }

    public void setClassPathSubstitions(List classPathSubstitions) {
        this.classPathSubstitutions = classPathSubstitions;
    }

    public void setClassPathProvider(String classPathProvider) {
        this.classPathProvider = classPathProvider;
    }

    public void setDisplayOutput(boolean displayOutput) {
        this.displayOutput = displayOutput;
    }

    String getOutputFileName(Fitnesse pServer) {
        return this.getResultFileName(pServer, "_output", "txt");
    }

    String getOutputUrl(Fitnesse pServer) {
        return "fitnesseResult_" + pServer.getHostName() + "_" + pServer.getPageName() + "_output.txt";
    }

    public void setCopyDependencies(boolean copyDependencies) {
        this.copyDependencies = copyDependencies;
    }
}

