/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.Vector;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JDocComment;
import org.codehaus.modello.plugin.java.javasource.JDocDescriptor;
import org.codehaus.modello.plugin.java.javasource.JMember;
import org.codehaus.modello.plugin.java.javasource.JMethodSignature;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;

public class JMethod
implements JMember {
    private Vector _classes = null;
    private JDocComment jdc = null;
    private JSourceCode source = null;
    private JMethodSignature _signature = null;

    public JMethod(String name) {
        this(name, null, null);
    }

    public JMethod(JType returnType, String name) {
        this(name, returnType, null);
    }

    public JMethod(String name, JType returnType, String returnDoc) {
        if (name == null || name.length() == 0) {
            String err = "The method name must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this._classes = new Vector(1);
        this.source = new JSourceCode();
        this._signature = new JMethodSignature(name, returnType);
        this.jdc = this._signature.getJDocComment();
        this.jdc.appendComment("Method " + name + ".");
        if (returnType != null) {
            if (returnDoc != null && returnDoc.length() > 0) {
                this.jdc.addDescriptor(JDocDescriptor.createReturnDesc(returnDoc));
            } else {
                this.jdc.addDescriptor(JDocDescriptor.createReturnDesc(returnType.getLocalName()));
            }
        }
    }

    public void addException(JClass exp) {
        this._signature.addException(exp);
    }

    public void addParameter(JParameter parameter) throws IllegalArgumentException {
        this._signature.addParameter(parameter);
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JClass[] getExceptions() {
        return this._signature.getExceptions();
    }

    public JModifiers getModifiers() {
        return this._signature.getModifiers();
    }

    public String getName() {
        return this._signature.getName();
    }

    public JParameter getParameter(int index) {
        return this._signature.getParameter(index);
    }

    public JParameter[] getParameters() {
        return this._signature.getParameters();
    }

    public JType getReturnType() {
        return this._signature.getReturnType();
    }

    public JMethodSignature getSignature() {
        return this._signature;
    }

    public JSourceCode getSourceCode() {
        return this.source;
    }

    public void setComment(String comment) {
        this.jdc.setComment(comment);
    }

    public void setModifiers(JModifiers modifiers) {
        this._signature.setModifiers(modifiers);
    }

    public void setSourceCode(String source) {
        this.source = new JSourceCode(source);
    }

    public void setSourceCode(JSourceCode source) {
        this.source = source;
    }

    public void print(JSourceWriter jsw) {
        this.jdc.print(jsw);
        this._signature.print(jsw, false);
        if (this._signature.getModifiers().isAbstract()) {
            jsw.writeln(";");
        } else {
            jsw.writeln();
            jsw.writeln("{");
            this.source.print(jsw);
            jsw.write("} //-- ");
            jsw.writeln(this.toString());
        }
    }

    public String toString() {
        return this._signature.toString();
    }

    protected void addDeclaringClass(JClass jClass) {
        this._classes.addElement(jClass);
    }

    protected void removeDeclaringClass(JClass jClass) {
        this._classes.removeElement(jClass);
    }

    protected String[] getParameterClassNames() {
        return this._signature.getParameterClassNames();
    }
}

