/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.schemaobject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.DDLWriter;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.schemaobject.AbstractSchemaObject;
import org.castor.ddlgen.schemaobject.KeyGenerator;
import org.castor.ddlgen.schemaobject.Table;
import org.castor.ddlgen.typeinfo.TypeInfo;

public abstract class Field
extends AbstractSchemaObject {
    private static final Log LOG = LogFactory.getLog(Field.class);
    private KeyGenerator _keyGenerator;
    private boolean _isIdentity;
    private boolean _isRequired;
    private TypeInfo _type;
    private Table _table;

    public final void setKeyGenerator(KeyGenerator keyGenerator) {
        this._keyGenerator = keyGenerator;
    }

    public final KeyGenerator getKeyGenerator() {
        return this._keyGenerator;
    }

    public final void setIdentity(boolean isIdentity) {
        this._isIdentity = isIdentity;
    }

    public final boolean isIdentity() {
        return this._isIdentity;
    }

    public final void setRequired(boolean isRequired) {
        this._isRequired = isRequired;
    }

    public final boolean isRequired() {
        return this._isRequired;
    }

    public final void setType(TypeInfo type) {
        this._type = type;
    }

    public final TypeInfo getType() {
        return this._type;
    }

    public final void setTable(Table table) {
        this._table = table;
    }

    public final Table getTable() {
        return this._table;
    }

    public final Integer getLength() {
        return null;
    }

    public final Integer getPrecision() {
        return null;
    }

    public final Integer getDecimals() {
        return null;
    }

    public final void toDropDDL(DDLWriter writer) {
    }

    public final void merge(Field field) throws GeneratorException {
        if (field == null) {
            String msg = "Field to merge is missing.";
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (!Field.equals(this.getName(), field.getName())) {
            String msg = "Name of field differs from: " + this.getName();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (!Field.equals(this.getTable(), field.getTable())) {
            String msg = "Table of field differs from: " + this.getTable().getName();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (this._isIdentity != field._isIdentity) {
            LOG.warn((Object)"Merge table: Field 'identity' attributes are different");
        }
        if (this._isRequired != field._isRequired) {
            LOG.warn((Object)"Merge table: Field 'required' attributes are different");
        }
        this._type.merge(field._type);
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Field field = (Field)other;
        return Field.equals(this.getName(), field.getName()) && Field.equals(this._table, field._table) && Field.equals(this._type, field._type) && this._isRequired == field._isRequired && this._isIdentity == field._isIdentity && Field.equals(this._keyGenerator, field._keyGenerator);
    }

    public final int hashCode() {
        int hashCode = 0;
        if (this.getName() != null) {
            hashCode += this.getName().hashCode();
        }
        hashCode *= 17;
        if (this._table != null) {
            hashCode += this._table.hashCode();
        }
        hashCode *= 17;
        if (this._type != null) {
            hashCode += this._type.hashCode();
        }
        hashCode *= 17;
        hashCode += Boolean.valueOf(this._isRequired).hashCode();
        hashCode *= 17;
        hashCode += Boolean.valueOf(this._isIdentity).hashCode();
        hashCode *= 17;
        if (this._keyGenerator != null) {
            hashCode += this._keyGenerator.hashCode();
        }
        return hashCode;
    }
}

