/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.engine.mysql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.AbstractTypeMapper;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.typeinfo.NoParamType;
import org.castor.ddlgen.typeinfo.OptionalLengthType;
import org.castor.ddlgen.typeinfo.OptionalPrecisionDecimalsType;
import org.castor.ddlgen.typeinfo.OptionalPrecisionType;
import org.castor.ddlgen.typeinfo.RequiredLengthType;

public final class MysqlTypeMapper
extends AbstractTypeMapper {
    private static final Log LOG = LogFactory.getLog(MysqlTypeMapper.class);

    public MysqlTypeMapper(DDLGenConfiguration conf) {
        super(conf);
    }

    protected void initialize(DDLGenConfiguration conf) {
        this.add(new NoParamType("bit", "TINYINT(1)"));
        this.add(new OptionalPrecisionType("tinyint", "TINYINT", conf));
        this.add(new OptionalPrecisionType("smallint", "SMALLINT", conf));
        this.add(new OptionalPrecisionType("integer", "INTEGER", conf));
        this.add(new OptionalPrecisionType("int", "INTEGER", conf));
        this.add(new OptionalPrecisionType("bigint", "BIGINT", conf));
        this.add(new OptionalPrecisionDecimalsType("float", "FLOAT", conf));
        this.add(new OptionalPrecisionDecimalsType("double", "DOUBLE", conf));
        this.add(new OptionalPrecisionDecimalsType("real", "REAL", conf));
        this.add(new OptionalPrecisionDecimalsType("numeric", "NUMERIC", conf));
        this.add(new OptionalPrecisionDecimalsType("decimal", "DECIMAL", conf));
        this.add(new OptionalLengthType("char", "CHAR", conf));
        this.add(new OptionalLengthType("varchar", "VARCHAR", conf));
        LOG.warn((Object)"MySql does not support 'LONGVARCHAR' type, use VARCHAR instead.");
        this.add(new OptionalLengthType("longvarchar", "VARCHAR", conf));
        this.add(new NoParamType("date", "DATE"));
        this.add(new NoParamType("time", "TIME"));
        this.add(new OptionalPrecisionType("timestamp", "TIMESTAMP", conf));
        this.add(new RequiredLengthType("binary", "BINARY", conf));
        this.add(new RequiredLengthType("varbinary", "VARBINARY", conf));
        LOG.warn((Object)"MySql does not support 'LONGBINARY' type, use VARBINARY instead.");
        this.add(new RequiredLengthType("longvarbinary", "VARBINARY", conf));
        this.add(new NoParamType("other", "BLOB"));
        this.add(new NoParamType("javaobject", "BLOB"));
        this.add(new NoParamType("blob", "BLOB"));
        this.add(new NoParamType("clob", "TEXT"));
    }
}

