/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.engine.mssql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.AbstractTypeMapper;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.typeinfo.NoParamType;
import org.castor.ddlgen.typeinfo.OptionalLengthType;
import org.castor.ddlgen.typeinfo.OptionalPrecisionDecimalsType;
import org.castor.ddlgen.typeinfo.OptionalPrecisionType;

public final class MssqlTypeMapper
extends AbstractTypeMapper {
    private static final Log LOG = LogFactory.getLog(MssqlTypeMapper.class);

    public MssqlTypeMapper(DDLGenConfiguration conf) {
        super(conf);
    }

    protected void initialize(DDLGenConfiguration conf) {
        this.add(new NoParamType("bit", "BIT"));
        this.add(new NoParamType("tinyint", "TINYINT"));
        this.add(new NoParamType("smallint", "SMALLINT"));
        this.add(new NoParamType("integer", "INTEGER"));
        this.add(new NoParamType("int", "INTEGER"));
        this.add(new NoParamType("bigint", "BIGINT"));
        this.add(new OptionalPrecisionType("float", "FLOAT", conf));
        this.add(new NoParamType("double", "DOUBLE PRECISION"));
        this.add(new NoParamType("real", "REAL"));
        this.add(new OptionalPrecisionDecimalsType("numeric", "NUMERIC", conf));
        this.add(new OptionalPrecisionDecimalsType("decimal", "DECIMAL", conf));
        this.add(new OptionalLengthType("char", "CHAR", conf));
        this.add(new OptionalLengthType("varchar", "VARCHAR", conf));
        LOG.warn((Object)"MS SQL does not support 'LONGVARCHAR' type, use TEXT instead.");
        this.add(new NoParamType("longvarchar", "TEXT"));
        this.add(new NoParamType("date", "DATETIME"));
        this.add(new NoParamType("time", "DATETIME"));
        this.add(new NoParamType("timestamp", "TIMESTAMP"));
        this.add(new OptionalLengthType("binary", "BINARY", conf));
        this.add(new OptionalLengthType("varbinary", "VARBINARY", conf));
        this.add(new NoParamType("longvarbinary", "IMAGE"));
        this.add(new NoParamType("other", "IMAGE"));
        this.add(new NoParamType("javaobject", "IMAGE"));
        this.add(new NoParamType("blob", "IMAGE"));
        this.add(new NoParamType("clob", "TEXT"));
    }
}

