/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.Generator;
import org.castor.ddlgen.GeneratorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneratorRegistry {
    private static final Log LOG = LogFactory.getLog(GeneratorRegistry.class);
    private Map<String, Generator> _generators = new Hashtable<String, Generator>();

    public GeneratorRegistry(DDLGenConfiguration config) {
        String prop = config.getStringValue("org.castor.ddlgen.Generators", "");
        StringTokenizer tokenizer = new StringTokenizer(prop, ",");
        ClassLoader loader = GeneratorRegistry.class.getClassLoader();
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken().trim();
            try {
                Class<?> cls = loader.loadClass(classname);
                Class[] types = new Class[]{DDLGenConfiguration.class};
                Object[] params = new Object[]{config};
                Constructor<?> cst = cls.getConstructor(types);
                Generator generator = (Generator)cst.newInstance(params);
                this._generators.put(generator.getEngineName(), generator);
            }
            catch (Exception ex) {
                String msg = "Problem instantiating generator: ";
                LOG.error((Object)(msg + classname), (Throwable)ex);
            }
        }
    }

    public Generator getGenerator(String engine) throws GeneratorException {
        if (engine == null) {
            throw new GeneratorException("No database engine specified");
        }
        Generator generator = this._generators.get(engine);
        if (generator == null) {
            throw new GeneratorException("Unknown DDL generator: " + engine);
        }
        return generator;
    }

    public Collection<Generator> getGenerators() {
        return Collections.unmodifiableCollection(this._generators.values());
    }

    public Collection<String> getEngineNames() {
        return Collections.unmodifiableCollection(this._generators.keySet());
    }
}

