/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.castor.ddlgen.Configuration;
import org.castor.ddlgen.DDLGenConfiguration;

public final class DDLWriter
extends Writer {
    private Writer _writer;
    private IOException _error = null;
    private boolean _isNewline = true;
    private int _indentLevel = 0;
    private String _indentText = "    ";
    private String _newline = DDLGenConfiguration.DEFAULT_NEWLINE;
    private String _chrFormat = "SENSITIVE";

    public DDLWriter(OutputStream output, Configuration conf) {
        this(new BufferedWriter(new OutputStreamWriter(output)), conf);
    }

    public DDLWriter(Writer writer, Configuration conf) {
        super((Object)writer);
        this._writer = writer;
        this._newline = conf.getStringValue("org.castor.ddlgen.Newline", DDLGenConfiguration.DEFAULT_NEWLINE);
        this._indentText = conf.getStringValue("org.castor.ddlgen.Indention", "    ");
        this._chrFormat = conf.getStringValue("org.castor.ddlgen.CharFormat", "SENSITIVE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this._writer == null) {
                    throw new IOException("Writer closed.");
                }
                this._writer.flush();
            }
        }
        catch (IOException ex) {
            this._error = ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this._writer != null) {
                    this._writer.close();
                    this._writer = null;
                }
            }
        }
        catch (IOException ex) {
            this._error = ex;
        }
    }

    public void checkError() throws IOException {
        if (this._error != null) {
            throw this._error;
        }
    }

    public void indent() {
        ++this._indentLevel;
    }

    public void unindent() {
        this._indentLevel = this._indentLevel <= 0 ? 0 : this._indentLevel - 1;
    }

    public void write(char[] buf, int off, int len) {
        this.write(new String(buf, off, len));
    }

    public void write(char[] buf) {
        this.write(new String(buf));
    }

    public void write(int c) {
        this.write(new String(new char[]{(char)c}));
    }

    public void write(String s, int off, int len) {
        this.write(s.substring(off, off + len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) {
        if (s != null) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this._writer == null) {
                        throw new IOException("Writer closed.");
                    }
                    if ("LOWER".equalsIgnoreCase(this._chrFormat)) {
                        this._writer.write(s.toLowerCase());
                    } else if ("UPPER".equalsIgnoreCase(this._chrFormat)) {
                        this._writer.write(s.toUpperCase());
                    } else {
                        this._writer.write(s);
                    }
                }
            }
            catch (InterruptedIOException ex) {
                Thread.currentThread().interrupt();
            }
            catch (IOException ex) {
                this._error = ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndention() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this._writer == null) {
                    throw new IOException("Writer closed.");
                }
                if (this._isNewline) {
                    for (int i = 0; i < this._indentLevel; ++i) {
                        this._writer.write(this._indentText);
                    }
                    this._isNewline = false;
                }
            }
        }
        catch (InterruptedIOException ex) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ex) {
            this._error = ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNewline() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this._writer == null) {
                    throw new IOException("Writer closed.");
                }
                this._isNewline = true;
                this._writer.write(this._newline);
            }
        }
        catch (InterruptedIOException ex) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ex) {
            this._error = ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char[] chars) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(chars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(double number) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(String.valueOf(number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int number) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(String.valueOf(number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(long number) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(String.valueOf(number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.writeIndention();
            this.write(String.valueOf(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String pattern, Object[] arguments) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(MessageFormat.format(pattern, arguments));
        }
    }

    public void println() {
        this.writeNewline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] chars) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(chars);
            this.writeNewline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double number) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(String.valueOf(number));
            this.writeNewline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int number) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(String.valueOf(number));
            this.writeNewline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long number) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(String.valueOf(number));
            this.writeNewline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.writeIndention();
            this.write(String.valueOf(object));
            this.writeNewline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(string);
            this.writeNewline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String pattern, Object[] arguments) {
        Object object = this.lock;
        synchronized (object) {
            this.writeIndention();
            this.write(MessageFormat.format(pattern, arguments));
            this.writeNewline();
        }
    }
}

