/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.HashMap;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JMethodSignature;

public final class Java5HacksHelper {
    private static final HashMap<String, MethodSpec> DEFINED_SPECS = new HashMap();
    private static final JAnnotationType OVERRIDE_ANNOTATION;

    private Java5HacksHelper() {
    }

    private static void createMethodSpec(String methodName, int paramCount, String param1ClassName, String param2ClassName) {
        MethodSpec temp = new MethodSpec(methodName, paramCount, param1ClassName, param2ClassName);
        DEFINED_SPECS.put(methodName, temp);
    }

    public static void addOverrideAnnotations(JMethodSignature jms) {
        String name = jms.getName();
        boolean addOverrideAnnotation = false;
        JAnnotation override = jms.getAnnotation(OVERRIDE_ANNOTATION);
        if (override != null) {
            return;
        }
        MethodSpec methodSpec = DEFINED_SPECS.get(name);
        if (methodSpec == null) {
            return;
        }
        int paramCount = jms.getParameters().length;
        if (paramCount != methodSpec.getParamCount()) {
            return;
        }
        switch (paramCount) {
            case 0: {
                addOverrideAnnotation = true;
                break;
            }
            case 1: {
                String incomingClassName1 = jms.getParameter(0).getType().getName();
                if (!incomingClassName1.equalsIgnoreCase(methodSpec.getParam1ClassName())) break;
                addOverrideAnnotation = true;
                break;
            }
            case 2: {
                String className1 = jms.getParameter(0).getType().getName();
                String className2 = jms.getParameter(1).getType().getName();
                if (!className1.equalsIgnoreCase(methodSpec.getParam1ClassName()) || !className2.equalsIgnoreCase(methodSpec.getParam2ClassName())) break;
                addOverrideAnnotation = true;
                break;
            }
        }
        if (addOverrideAnnotation) {
            jms.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
    }

    static {
        Java5HacksHelper.createMethodSpec("getAccessMode", 0, "", "");
        Java5HacksHelper.createMethodSpec("getNameSpacePrefix", 0, "", "");
        Java5HacksHelper.createMethodSpec("getNameSpaceURI", 0, "", "");
        Java5HacksHelper.createMethodSpec("getValidator", 0, "", "");
        Java5HacksHelper.createMethodSpec("getXMLName", 0, "", "");
        Java5HacksHelper.createMethodSpec("getXTransients", 0, "", "");
        Java5HacksHelper.createMethodSpec("newInstance", 1, "java.lang.Object", "");
        Java5HacksHelper.createMethodSpec("setValue", 1, "java.lang.Object", "");
        Java5HacksHelper.createMethodSpec("equals", 1, "java.lang.Object", "");
        Java5HacksHelper.createMethodSpec("getValue", 1, "java.lang.Object", "");
        Java5HacksHelper.createMethodSpec("marshal", 1, "java.io.Writer", "");
        Java5HacksHelper.createMethodSpec("newInstance", 1, "java.lang.Object", "");
        Java5HacksHelper.createMethodSpec("setValue", 2, "java.lang.Object", "java.lang.Object");
        Java5HacksHelper.createMethodSpec("setXTransients", 1, "org.openmrm.core.data.castor.XTransients", "");
        OVERRIDE_ANNOTATION = new JAnnotationType("Override");
    }

    private static class MethodSpec {
        private String _methodName;
        private int _paramCount;
        private String _param1ClassName;
        private String _param2ClassName;

        public MethodSpec(String methodName, int paramCount, String param1ClassName, String param2ClassName) {
            this._methodName = methodName;
            this._paramCount = paramCount;
            this._param1ClassName = param1ClassName;
            this._param2ClassName = param2ClassName;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public int getParamCount() {
            return this._paramCount;
        }

        public String getParam1ClassName() {
            return this._param1ClassName;
        }

        public String getParam2ClassName() {
            return this._param2ClassName;
        }
    }
}

