/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JAnnotatedElement;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JCollectionType;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethodSignature;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public final class JMethod
implements JMember,
JAnnotatedElement {
    private final Vector _classes;
    private JDocComment _jdc = null;
    private JSourceCode _source = null;
    private JMethodSignature _signature = null;

    public JMethod(String name) {
        if (name == null || name.length() == 0) {
            String err = "The method name must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this._classes = new Vector(1);
        this._source = new JSourceCode();
        this._signature = new JMethodSignature(name);
        this._jdc = this._signature.getJDocComment();
    }

    public JMethod(String name, JType returnType, String returnDoc) {
        this(name);
        this._signature = new JMethodSignature(name, returnType);
        this._jdc = this._signature.getJDocComment();
        this._jdc.appendComment("Method " + name + ".");
        if (returnDoc != null && returnDoc.length() > 0) {
            this._jdc.addDescriptor(JDocDescriptor.createReturnDesc(returnDoc));
        } else {
            this._jdc.addDescriptor(JDocDescriptor.createReturnDesc(returnType.getLocalName()));
        }
    }

    public void addException(JClass exp, String description) {
        this._signature.addException(exp);
        this._jdc.addDescriptor(JDocDescriptor.createExceptionDesc(exp.getName(), description));
    }

    public void addParameter(JParameter parameter) {
        this._signature.addParameter(parameter);
        JType jType = parameter.getType();
        while (jType.isArray() || jType instanceof JCollectionType) {
            if (jType.isArray()) {
                jType = ((JArrayType)jType).getComponentType();
                continue;
            }
            jType = ((JCollectionType)jType).getComponentType();
        }
        if (!jType.isPrimitive()) {
            JClass jClass = (JClass)jType;
            for (int i = 0; i < this._classes.size(); ++i) {
                ((JClass)this._classes.elementAt(i)).addImport(jClass.getName());
            }
        }
    }

    public JDocComment getJDocComment() {
        return this._jdc;
    }

    public JClass[] getExceptions() {
        return this._signature.getExceptions();
    }

    public int getExceptionCount() {
        return this._signature.getExceptions().length;
    }

    public JModifiers getModifiers() {
        return this._signature.getModifiers();
    }

    public String getName() {
        return this._signature.getName();
    }

    public JParameter getParameter(int index) {
        return this._signature.getParameter(index);
    }

    public JParameter[] getParameters() {
        return this._signature.getParameters();
    }

    public int getParameterCount() {
        return this._signature.getParameters().length;
    }

    public JType getReturnType() {
        return this._signature.getReturnType();
    }

    public JMethodSignature getSignature() {
        return this._signature;
    }

    public JSourceCode getSourceCode() {
        return this._source;
    }

    public void setName(String name) {
        this._signature.setName(name);
    }

    public void setComment(String comment) {
        this._jdc.setComment(comment);
    }

    public void setModifiers(JModifiers modifiers) {
        this._signature.setModifiers(modifiers);
    }

    public void setSourceCode(String source) {
        this._source = new JSourceCode(source);
    }

    public void setSourceCode(JSourceCode source) {
        this._source = source;
    }

    public String toString() {
        return this._signature.toString();
    }

    public JAnnotation getAnnotation(JAnnotationType annotationType) {
        return this._signature.getAnnotation(annotationType);
    }

    public JAnnotation[] getAnnotations() {
        return this._signature.getAnnotations();
    }

    public boolean isAnnotationPresent(JAnnotationType annotationType) {
        return this._signature.isAnnotationPresent(annotationType);
    }

    public void addAnnotation(JAnnotation annotation) {
        this._signature.addAnnotation(annotation);
    }

    public JAnnotation removeAnnotation(JAnnotationType annotationType) {
        return this._signature.removeAnnotation(annotationType);
    }

    public boolean hasAnnotations() {
        return this._signature.hasAnnotations();
    }

    public void print(JSourceWriter jsw) {
        this._jdc.print(jsw);
        this._signature.print(jsw, false);
        if (this._signature.getModifiers().isAbstract()) {
            jsw.writeln(";");
        } else {
            jsw.writeln(" {");
            this._source.print(jsw);
            jsw.writeln("}");
        }
    }
}

