/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.LinkedHashMap;
import org.exolab.javasource.JAnnotatedElement;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JSourceWriter;

public class JAnnotatedElementHelper
implements JAnnotatedElement {
    private LinkedHashMap<String, JAnnotation> _annotations = new LinkedHashMap();

    public final JAnnotation getAnnotation(JAnnotationType annotationType) {
        if (this._annotations == null) {
            return null;
        }
        return this._annotations.get(annotationType.getName());
    }

    public final JAnnotation[] getAnnotations() {
        return this._annotations.values().toArray(new JAnnotation[this._annotations.size()]);
    }

    public final boolean isAnnotationPresent(JAnnotationType annotationType) {
        return this._annotations.containsKey(annotationType.getName());
    }

    public final void addAnnotation(JAnnotation annotation) {
        if (this.isAnnotationPresent(annotation.getAnnotationType())) {
            throw new IllegalArgumentException("Annotation for '" + annotation.getAnnotationType().getName() + "' already added.");
        }
        String annotationType = annotation.getAnnotationType().getName();
        this._annotations.put(annotationType, annotation);
    }

    public final JAnnotation removeAnnotation(JAnnotationType annotationType) {
        if (!this.isAnnotationPresent(annotationType)) {
            throw new IllegalArgumentException("Annotation for '" + annotationType.getName() + "' not present.");
        }
        return (JAnnotation)this._annotations.remove(annotationType.getName());
    }

    public final boolean hasAnnotations() {
        return this._annotations.size() > 0;
    }

    public final boolean printAnnotations(JSourceWriter jsw) {
        boolean printed = false;
        for (JAnnotation annotation : this._annotations.values()) {
            annotation.print(jsw);
            jsw.writeln();
            printed = true;
        }
        return printed;
    }
}

