/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.ClassInfoResolver;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.factory.BaseFactory;
import org.exolab.castor.builder.factory.FieldInfoFactory;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.NodeType;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSListType;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JPrimitiveType;
import org.exolab.javasource.JType;

public final class MemberFactory
extends BaseFactory {
    public MemberFactory(BuilderConfiguration config, FieldInfoFactory infoFactory, GroupNaming groupNaming, SourceGenerator sourceGenerator) {
        super(config, infoFactory, groupNaming, sourceGenerator);
        if (this.getConfig().generateExtraCollectionMethods()) {
            this.getInfoFactory().setCreateExtraMethods(true);
        }
        String suffix = this.getConfig().getProperty("org.exolab.castor.builder.collections.reference.suffix", null);
        this.getInfoFactory().setReferenceMethodSuffix(suffix);
        if (this.getConfig().boundPropertiesEnabled()) {
            this.getInfoFactory().setBoundProperties(true);
        }
    }

    public FieldInfo createFieldInfoForAny(Wildcard any, boolean useJava50) {
        if (any == null) {
            return null;
        }
        if (any.isAttributeWildcard()) {
            return null;
        }
        XSClass xsType = new XSClass(SGTypes.OBJECT, "any");
        String vName = "_anyObject";
        String xmlName = null;
        FieldInfo result = null;
        if (any.getMaxOccurs() > 1 || any.getMaxOccurs() < 0) {
            result = this.getInfoFactory().createCollection(xsType, vName, "anyObject", this.getJavaNaming(), useJava50);
            XSListType xsList = ((CollectionInfo)result).getXSList();
            xsList.setMinimumSize(any.getMinOccurs());
            xsList.setMaximumSize(any.getMaxOccurs());
        } else {
            result = this.getInfoFactory().createFieldInfo(xsType, vName);
        }
        if (result.hasNature(XMLInfoNature.class.getName())) {
            String nsURI;
            XMLInfoNature xmlNature = new XMLInfoNature(result);
            if (any.getMinOccurs() > 0) {
                xmlNature.setRequired(true);
            } else {
                xmlNature.setRequired(false);
            }
            xmlNature.setNodeName(xmlName);
            if (any.getNamespaces().hasMoreElements() && (nsURI = (String)any.getNamespaces().nextElement()).length() > 0) {
                if (nsURI.equals("##targetNamespace")) {
                    Schema schema = any.getSchema();
                    if (schema != null) {
                        xmlNature.setNamespaceURI(schema.getTargetNamespace());
                    }
                } else if (!nsURI.startsWith("##")) {
                    xmlNature.setNamespaceURI(nsURI);
                }
            }
        }
        return result;
    }

    public FieldInfo createFieldInfoForChoiceValue() {
        String fieldName = "_choiceValue";
        XSClass xsType = new XSClass(SGTypes.OBJECT, "any");
        FieldInfo fInfo = null;
        fInfo = this.getInfoFactory().createFieldInfo(xsType, fieldName);
        fInfo.setComment("Internal choice value storage");
        fInfo.setTransient(true);
        fInfo.setMethods(1);
        if (fInfo.hasNature(XMLInfoNature.class.getName())) {
            XMLInfoNature xmlNature = new XMLInfoNature(fInfo);
            xmlNature.setNodeType(NodeType.ELEMENT);
            xmlNature.setRequired(false);
            xmlNature.setNodeName("##any");
        }
        return fInfo;
    }

    public FieldInfo createFieldInfoForContent(XMLBindingComponent component, XSType xsType, boolean useJava50) {
        String fieldName = "_content";
        if (component.getContentMemberName() != null) {
            fieldName = component.getContentMemberName();
        }
        FieldInfo fInfo = null;
        fInfo = xsType.isCollection() ? this.getInfoFactory().createCollection(((XSListType)xsType).getContentType(), fieldName, null, this.getJavaNaming(), useJava50) : this.getInfoFactory().createFieldInfo(xsType, fieldName);
        fInfo.setComment("internal content storage");
        if (xsType instanceof XSString) {
            fInfo.setDefaultValue("\"\"");
        }
        if (fInfo.hasNature(XMLInfoNature.class.getName())) {
            XMLInfoNature xmlNature = new XMLInfoNature(fInfo);
            xmlNature.setNodeType(NodeType.TEXT);
            xmlNature.setRequired(false);
            xmlNature.setNodeName("#text");
        }
        return fInfo;
    }

    public FieldInfo createFieldInfo(XMLBindingComponent component, ClassInfoResolver resolver, boolean useJava50) {
        String comment;
        XMLInfoNature xmlNature;
        String xmlName = component.getXMLName();
        String memberName = component.getJavaMemberName();
        if (!memberName.startsWith("_")) {
            memberName = "_" + memberName;
        }
        XMLType xmlType = component.getXMLType();
        ClassInfo classInfo = resolver.resolve(component);
        XSType xsType = null;
        FieldInfo fieldInfo = null;
        boolean enumeration = false;
        boolean simpleTypeCollection = false;
        if (xmlType != null) {
            if (xmlType.isSimpleType()) {
                SimpleType simpleType = (SimpleType)xmlType;
                SimpleType baseType = null;
                String derivationMethod = simpleType.getDerivationMethod();
                if (derivationMethod != null && "restriction".equals(derivationMethod)) {
                    baseType = (SimpleType)simpleType.getBaseType();
                }
                if (simpleType.hasFacet("enumeration")) {
                    enumeration = true;
                    if (resolver != null) {
                        classInfo = resolver.resolve(xmlType);
                    }
                    if (classInfo != null) {
                        XMLInfoNature xmlNature2 = new XMLInfoNature(classInfo);
                        xsType = xmlNature2.getSchemaType();
                    }
                } else if (simpleType instanceof ListType || baseType instanceof ListType) {
                    SimpleType itemType;
                    ListType listType;
                    if (baseType != null) {
                        if (!baseType.isBuiltInType()) {
                            simpleTypeCollection = true;
                        }
                    } else if (!simpleType.isBuiltInType()) {
                        simpleTypeCollection = true;
                    }
                    if ((listType = (ListType)simpleType) == null) {
                        listType = (ListType)baseType;
                    }
                    if ((itemType = listType.getItemType()).hasFacet("enumeration")) {
                        ClassInfo itemClassInfo = resolver.resolve(itemType);
                        if (itemClassInfo != null) {
                            xsType = new XMLInfoNature(itemClassInfo).getSchemaType();
                        } else {
                            XMLBindingComponent temp = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
                            temp.setBinding(component.getBinding());
                            temp.setView((Annotated)itemType);
                            String packageName = temp.getJavaPackage();
                            packageName = packageName != null && packageName.length() > 0 ? packageName + "." + "types" : "types";
                            JClass tempClass = new JClass(packageName + "." + temp.getJavaClassName());
                            xsType = new XSClass(tempClass);
                            xsType.setAsEnumerated(true);
                        }
                    }
                }
                if (xsType == null) {
                    xsType = component.getJavaType();
                }
            } else if (xmlType.isAnyType()) {
                if (classInfo != null) {
                    XMLInfoNature xmlNature3 = new XMLInfoNature(classInfo);
                    xsType = xmlNature3.getSchemaType();
                }
                if (xsType == null) {
                    xsType = new XSClass(SGTypes.OBJECT);
                }
            } else if (xmlType.isComplexType() && xmlType.getName() != null && this.getConfig().mappingSchemaType2Java()) {
                XMLBindingComponent temp = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
                temp.setBinding(component.getBinding());
                temp.setView((Annotated)xmlType);
                ClassInfo typeInfo = resolver.resolve(xmlType);
                if (typeInfo != null) {
                    xmlNature = new XMLInfoNature(typeInfo);
                    xsType = xmlNature.getSchemaType();
                } else {
                    String className = temp.getQualifiedName();
                    if (className != null) {
                        JClass jClass = new JClass(className);
                        if (((ComplexType)xmlType).isAbstract()) {
                            jClass.getModifiers().setAbstract(true);
                        }
                        xsType = new XSClass(jClass);
                        className = null;
                    }
                }
            }
        } else {
            if (xsType == null) {
                xsType = component.getJavaType();
            }
            if (xsType == null) {
                switch (component.getAnnotated().getStructureType()) {
                    case 3: {
                        AttributeDecl attribute = (AttributeDecl)component.getAnnotated();
                        if (attribute.hasXMLType()) break;
                        xsType = new XSClass(SGTypes.OBJECT);
                        break;
                    }
                    case 8: {
                        ElementDecl element = (ElementDecl)component.getAnnotated();
                        if (element.hasXMLType()) break;
                        xsType = new XSClass(SGTypes.OBJECT);
                        break;
                    }
                }
            }
        }
        if (xsType == null) {
            ComplexType complexType;
            String className = component.getQualifiedName();
            JClass jClass = new JClass(className);
            if (component.isAbstract()) {
                jClass.getModifiers().setAbstract(true);
            }
            if (this.getConfig().isAutomaticConflictResolution()) {
                this.getSourceGenerator().getXMLInfoRegistry().bind(jClass, component, "field");
            }
            xsType = new XSClass(jClass);
            if (xmlType != null && xmlType.isComplexType() && ((complexType = (ComplexType)xmlType).isAbstract() || this.getConfig().mappingSchemaElement2Java())) {
                jClass.getModifiers().setAbstract(true);
            }
            className = null;
        }
        int maxOccurs = component.getUpperBound();
        int minOccurs = component.getLowerBound();
        if (simpleTypeCollection || (maxOccurs < 0 || maxOccurs > 1) && !this.isChoice(component)) {
            String vName = memberName + "List";
            CollectionInfo cInfo = this.getInfoFactory().createCollection(xsType, vName, memberName, component.getCollectionType(), this.getJavaNaming(), useJava50);
            XSListType xsList = cInfo.getXSList();
            if (!simpleTypeCollection) {
                xsList.setMaximumSize(maxOccurs);
                xsList.setMinimumSize(minOccurs);
            } else if (xsList instanceof XSList) {
                ((XSList)xsList).setDerivedFromXSList(true);
            }
            fieldInfo = cInfo;
        } else {
            switch (xsType.getType()) {
                case 25: {
                    fieldInfo = this.getInfoFactory().createIdentity(memberName);
                    break;
                }
                case 27: 
                case 31: 
                case 45: {
                    String collectionName = component.getCollectionType();
                    XSType contentType = ((XSListType)xsType).getContentType();
                    fieldInfo = this.getInfoFactory().createCollection(contentType, memberName, memberName, collectionName, this.getJavaNaming(), useJava50);
                    break;
                }
                default: {
                    fieldInfo = this.getInfoFactory().createFieldInfo(xsType, memberName);
                }
            }
        }
        xmlNature = new XMLInfoNature(fieldInfo);
        xmlNature.setNodeName(xmlName);
        xmlNature.setRequired(minOccurs > 0);
        switch (component.getAnnotated().getStructureType()) {
            case 8: {
                xmlNature.setNodeType(NodeType.ELEMENT);
                break;
            }
            case 3: {
                xmlNature.setNodeType(NodeType.ATTRIBUTE);
                break;
            }
            case 10: 
            case 16: {
                xmlNature.setNodeName("-error-if-this-is-used-");
                fieldInfo.setContainer(true);
                break;
            }
        }
        String nsURI = component.getTargetNamespace();
        if (nsURI != null && nsURI.length() > 0) {
            xmlNature.setNamespaceURI(nsURI);
        }
        this.handleDefaultValue(component, classInfo, xsType, fieldInfo, enumeration);
        if (component.isNillable()) {
            fieldInfo.setNillable(true);
        }
        if ((comment = this.createComment(component.getAnnotated())) != null) {
            fieldInfo.setComment(comment);
        }
        if (component.getXMLFieldHandler() != null) {
            fieldInfo.setXMLFieldHandler(component.getXMLFieldHandler());
        }
        if (component.getValidator() != null) {
            fieldInfo.setValidator(component.getValidator());
        }
        if (component.getVisiblity() != null) {
            String visibility = component.getVisiblity();
            fieldInfo.setVisibility(visibility);
        }
        switch (component.getAnnotated().getStructureType()) {
            case 8: {
                Enumeration possibleSubstitutes;
                ElementDecl elementDeclaration = (ElementDecl)component.getAnnotated();
                if (elementDeclaration.isReference()) {
                    elementDeclaration = elementDeclaration.getReference();
                }
                if (!(possibleSubstitutes = elementDeclaration.getSubstitutionGroupMembers()).hasMoreElements()) break;
                ArrayList<String> substitutionGroupMembers = new ArrayList<String>();
                while (possibleSubstitutes.hasMoreElements()) {
                    ElementDecl substitute = (ElementDecl)possibleSubstitutes.nextElement();
                    substitutionGroupMembers.add(substitute.getName());
                }
                fieldInfo.setSubstitutionGroupMembers(substitutionGroupMembers);
            }
        }
        return fieldInfo;
    }

    private boolean isChoice(XMLBindingComponent component) {
        Group group = this.getGroup((Structure)component.getAnnotated());
        if (group == null || group.getOrder() == null) {
            return false;
        }
        return group.getOrder() == Order.choice;
    }

    private Group getGroup(Structure structure) {
        if (structure == null) {
            return null;
        }
        if (structure.getStructureType() == 10) {
            return (Group)structure;
        }
        return null;
    }

    private void handleDefaultValue(XMLBindingComponent component, ClassInfo classInfo, XSType xsType, FieldInfo fieldInfo, boolean enumeration) {
        String value = component.getValue();
        if (value == null) {
            return;
        }
        if ((value = this.adjustDefaultValue(xsType, value)).length() == 0) {
            value = "\"\"";
        }
        if (xsType.getJType().toString().equals("java.lang.String")) {
            char ch = value.charAt(0);
            if (ch != '\'' && ch != '\"') {
                value = '\"' + value + '\"';
            }
            StringBuffer buffer = new StringBuffer(value.length());
            block3: for (int i = 0; i < value.length(); ++i) {
                char character = value.charAt(i);
                switch (character) {
                    case '\n': {
                        buffer.append("\\n");
                        continue block3;
                    }
                    default: {
                        buffer.append(character);
                    }
                }
            }
            value = buffer.toString();
        } else if (enumeration) {
            JType jType;
            JType jType2 = jType = classInfo != null ? classInfo.getJClass() : xsType.getJType();
            value = this.getSourceGenerator().useJava5Enums() ? jType.getName() + ".fromValue(\"" + value + "\")" : jType.getName() + ".valueOf(\"" + value + "\")";
        } else if (xsType.getJType().isArray()) {
            JType componentType = ((JArrayType)xsType.getJType()).getComponentType();
            if (componentType.isPrimitive()) {
                JPrimitiveType primitive = (JPrimitiveType)componentType;
                value = "new " + primitive.getName() + "[] { " + primitive.getWrapperName() + ".valueOf(\"" + value + "\")." + primitive.getName() + "Value() }";
            } else {
                value = "new " + componentType.getName() + "[] { " + componentType.getName() + ".valueOf(\"" + value + "\") }";
            }
        } else if (!xsType.getJType().isPrimitive()) {
            value = xsType.isDateTime() ? (xsType.getType() == 3 ? "new org.exolab.castor.types.DateTime(\"" + value + "\").toDate()" : "new " + xsType.getJType().getName() + "(\"" + value + "\")") : "new " + xsType.getJType().getName() + "(\"" + value + "\")";
        }
        if (component.isFixed()) {
            fieldInfo.setFixedValue(value);
        } else {
            fieldInfo.setDefaultValue(value);
        }
    }

    private String adjustDefaultValue(XSType xsType, String value) {
        switch (xsType.getType()) {
            case 14: {
                return value + 'f';
            }
            case 11: {
                Boolean bool = new Boolean(value);
                return bool.toString();
            }
        }
        return value;
    }
}

