/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.exolab.castor.builder.BaseFactory;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.FactoryState;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.binding.xml.EnumBindingType;
import org.exolab.castor.builder.binding.xml.EnumMember;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class EnumerationFactory
extends BaseFactory {
    private TypeConversion _typeConversion = new TypeConversion(this.getConfig());
    private boolean _caseInsensitive = false;
    private int _maxSuffix = 0;
    private int _maxEnumerationsPerClass;

    public EnumerationFactory(BuilderConfiguration config, GroupNaming groupNaming) {
        super(config, null, groupNaming);
        this._maxEnumerationsPerClass = config.getMaximumNumberOfConstants();
    }

    void processEnumerationAsNewObject(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        this._maxSuffix = 0;
        boolean generateConstantDefinitions = true;
        int numberOfEnumerationFacets = simpleType.getNumberOfFacets("enumeration");
        if (numberOfEnumerationFacets > this._maxEnumerationsPerClass) {
            generateConstantDefinitions = false;
        }
        Enumeration enumeration = simpleType.getFacets("enumeration");
        XMLBindingComponent component = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (binding != null) {
            component.setBinding(binding);
            component.setView((Annotated)simpleType);
        }
        boolean useValuesAsName = true;
        useValuesAsName = this.selectNamingScheme(component, enumeration, useValuesAsName);
        enumeration = simpleType.getFacets("enumeration");
        JClass jClass = state.getJClass();
        String className = jClass.getLocalName();
        if (component.getJavaClassName() != null) {
            className = component.getJavaClassName();
        }
        jClass.addImport("java.util.Hashtable");
        JField field = null;
        JField fHash = new JField(SGTypes.createHashtable(this.getConfig().useJava50()), "_memberTable");
        fHash.setInitString("init()");
        fHash.getModifiers().setStatic(true);
        JSourceCode jsc = null;
        JConstructor constructor = jClass.getConstructor(0);
        constructor.getModifiers().makePrivate();
        constructor.addParameter(new JParameter(JType.INT, "type"));
        constructor.addParameter(new JParameter(SGTypes.STRING, "value"));
        jsc = constructor.getSourceCode();
        jsc.add("this.type = type;");
        jsc.add("this.stringValue = value;");
        this.createValueOfMethod(jClass, className);
        this.createEnumerateMethod(jClass, className);
        this.createToStringMethod(jClass, className);
        this.createInitMethod(jClass);
        this.createReadResolveMethod(jClass);
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String value = facet.getValue();
            String typeName = null;
            String objName = null;
            objName = useValuesAsName ? this.translateEnumValueToIdentifier(component.getEnumBinding(), facet) : "VALUE_" + count;
            typeName = objName + "_TYPE";
            boolean addInitializerCode = true;
            if (jClass.getField(objName) != null) {
                jClass.removeField(objName);
                jClass.removeField(typeName);
                addInitializerCode = false;
            }
            if (generateConstantDefinitions) {
                field = new JField(JType.INT, typeName);
                field.setComment("The " + value + " type");
                JModifiers modifiers = field.getModifiers();
                modifiers.setFinal(true);
                modifiers.setStatic(true);
                modifiers.makePublic();
                field.setInitString(Integer.toString(count));
                jClass.addField(field);
                field = new JField(jClass, objName);
                field.setComment("The instance of the " + value + " type");
                modifiers = field.getModifiers();
                modifiers.setFinal(true);
                modifiers.setStatic(true);
                modifiers.makePublic();
                StringBuffer init = new StringBuffer();
                init.append("new ");
                init.append(className);
                init.append("(");
                init.append(typeName);
                init.append(", \"");
                init.append(EnumerationFactory.escapeValue(value));
                init.append("\")");
                field.setInitString(init.toString());
                jClass.addField(field);
            }
            if (addInitializerCode) {
                jsc = this.getSourceCodeForInitMethod(jClass);
                jsc.add("members.put(\"");
                jsc.append(EnumerationFactory.escapeValue(value));
                if (this._caseInsensitive) {
                    jsc.append("\".toLowerCase(), ");
                } else {
                    jsc.append("\", ");
                }
                if (generateConstantDefinitions) {
                    jsc.append(objName);
                } else {
                    StringBuffer init = new StringBuffer();
                    init.append("new ");
                    init.append(className);
                    init.append("(");
                    init.append(Integer.toString(count));
                    init.append(", \"");
                    init.append(EnumerationFactory.escapeValue(value));
                    init.append("\")");
                    jsc.append(init.toString());
                }
                jsc.append(");");
            }
            ++count;
        }
        JMethod method = jClass.getMethod(this.getInitMethodName(this._maxSuffix), 0);
        method.getSourceCode().add("return members;");
        jClass.addField(fHash);
        field = new JField(JType.INT, "type");
        field.setInitString("-1");
        jClass.addField(field);
        field = new JField(SGTypes.STRING, "stringValue");
        field.setInitString("null");
        jClass.addField(field);
        this.createGetTypeMethod(jClass, className);
    }

    private JSourceCode getSourceCodeForInitMethod(JClass jClass) {
        JMethod currentInitMethod = jClass.getMethod(this.getInitMethodName(this._maxSuffix), 0);
        if (currentInitMethod.getSourceCode().size() > this._maxEnumerationsPerClass) {
            ++this._maxSuffix;
            JMethod mInit = this.createInitMethod(jClass);
            currentInitMethod.getSourceCode().add("members.putAll(" + mInit.getName() + "());");
            currentInitMethod.getSourceCode().add("return members;");
            return mInit.getSourceCode();
        }
        return currentInitMethod.getSourceCode();
    }

    private String getInitMethodName(int index) {
        if (index == 0) {
            return "init";
        }
        return "init" + index;
    }

    private boolean selectNamingScheme(XMLBindingComponent component, Enumeration enumeration, boolean useValuesAsName) {
        boolean duplicateTranslation = false;
        int numberOfTranslationToSpecialCharacter = 0;
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String possibleId = this.translateEnumValueToIdentifier(component.getEnumBinding(), facet);
            if (possibleId.equals("_") && (numberOfTranslationToSpecialCharacter = (int)((short)(numberOfTranslationToSpecialCharacter + 1))) > 1) {
                duplicateTranslation = true;
            }
            if (JavaNaming.isValidJavaIdentifier((String)possibleId)) continue;
            return false;
        }
        if (duplicateTranslation) {
            return false;
        }
        return useValuesAsName;
    }

    private void createGetTypeMethod(JClass jClass, String className) {
        JMethod mGetType = new JMethod("getType", JType.INT, "the type of this " + className);
        mGetType.getSourceCode().add("return this.type;");
        JDocComment jdc = mGetType.getJDocComment();
        jdc.appendComment("Returns the type of this " + className);
        jClass.addMethod(mGetType);
    }

    private void createReadResolveMethod(JClass jClass) {
        JMethod mReadResolve = new JMethod("readResolve", SGTypes.OBJECT, "this deserialized object");
        mReadResolve.getModifiers().makePrivate();
        jClass.addMethod(mReadResolve);
        JDocComment jdc = mReadResolve.getJDocComment();
        jdc.appendComment(" will be called during deserialization to replace ");
        jdc.appendComment("the deserialized object with the correct constant ");
        jdc.appendComment("instance.");
        JSourceCode jsc = mReadResolve.getSourceCode();
        jsc.add("return valueOf(this.stringValue);");
    }

    private JMethod createInitMethod(JClass jClass) {
        String initMethodName = this.getInitMethodName(this._maxSuffix);
        JMethod mInit = new JMethod(initMethodName, SGTypes.createHashtable(this.getConfig().useJava50()), "the initialized Hashtable for the member table");
        jClass.addMethod(mInit);
        mInit.getModifiers().makePrivate();
        mInit.getModifiers().setStatic(true);
        if (this.getConfig().useJava50()) {
            mInit.getSourceCode().add("Hashtable<Object, Object> members = new Hashtable<Object, Object>();");
        } else {
            mInit.getSourceCode().add("Hashtable members = new Hashtable();");
        }
        return mInit;
    }

    private void createToStringMethod(JClass jClass, String className) {
        JMethod mToString = new JMethod("toString", SGTypes.STRING, "the String representation of this " + className);
        jClass.addMethod(mToString);
        JDocComment jdc = mToString.getJDocComment();
        jdc.appendComment("Returns the String representation of this ");
        jdc.appendComment(className);
        mToString.getSourceCode().add("return this.stringValue;");
    }

    private void createEnumerateMethod(JClass jClass, String className) {
        JMethod mEnumerate = new JMethod("enumerate", SGTypes.createEnumeration(SGTypes.OBJECT, this.getConfig().useJava50()), "an Enumeration over all possible instances of " + className);
        mEnumerate.getModifiers().setStatic(true);
        jClass.addMethod(mEnumerate);
        JDocComment jdc = mEnumerate.getJDocComment();
        jdc.appendComment("Returns an enumeration of all possible instances of ");
        jdc.appendComment(className);
        mEnumerate.getSourceCode().add("return _memberTable.elements();");
    }

    private void createValueOfMethod(JClass jClass, String className) {
        JMethod mValueOf = new JMethod("valueOf", jClass, "the " + className + " value of parameter 'string'");
        mValueOf.addParameter(new JParameter(SGTypes.STRING, "string"));
        mValueOf.getModifiers().setStatic(true);
        jClass.addMethod(mValueOf);
        JDocComment jdc = mValueOf.getJDocComment();
        jdc.appendComment("Returns a new " + className);
        jdc.appendComment(" based on the given String value.");
        JSourceCode jsc = mValueOf.getSourceCode();
        jsc.add("java.lang.Object obj = null;\nif (string != null) {\n obj = _memberTable.get(string{1});\n}\nif (obj == null) {\n String err = \"'\" + string + \"' is not a valid {0}\";\n throw new IllegalArgumentException(err);\n}\nreturn ({0}) obj;", className, this._caseInsensitive ? ".toLowerCase()" : "");
    }

    void processEnumerationAsBaseType(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        SimpleType base = (SimpleType)simpleType.getBaseType();
        XSType baseType = null;
        baseType = base == null ? new XSString() : this._typeConversion.convertType(base, this.getConfig().useJava50());
        Enumeration enumeration = simpleType.getFacets("enumeration");
        JClass jClass = state.getJClass();
        String className = jClass.getLocalName();
        JField fValues = null;
        JDocComment jdc = null;
        JSourceCode jsc = null;
        JConstructor constructor = jClass.getConstructor(0);
        constructor.getModifiers().makePrivate();
        fValues = new JField(new JArrayType(baseType.getJType(), this.getConfig().useJava50()), "values");
        int count = 0;
        StringBuffer values = new StringBuffer("{\n");
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String value = facet.getValue();
            if (count > 0) {
                values.append(",\n");
            }
            values.append("    ");
            if (baseType.getType() == 1) {
                values.append('\"');
                values.append(EnumerationFactory.escapeValue(value));
                values.append('\"');
            } else {
                values.append(value);
            }
            ++count;
        }
        values.append("\n}");
        fValues.setInitString(values.toString());
        jClass.addField(fValues);
        JMethod method = new JMethod("valueOf", jClass, "the String value of the provided " + baseType.getJType());
        method.addParameter(new JParameter(SGTypes.STRING, "string"));
        method.getModifiers().setStatic(true);
        jClass.addMethod(method);
        jdc = method.getJDocComment();
        jdc.appendComment("Returns the " + baseType.getJType());
        jdc.appendComment(" based on the given String value.");
        jsc = method.getSourceCode();
        jsc.add("for (int i = 0; i < values.length; i++) {");
        jsc.add("}");
        jsc.add("throw new IllegalArgumentException(\"");
        jsc.append("Invalid value for ");
        jsc.append(className);
        jsc.append(": \" + string + \".\");");
    }

    private String translateEnumValueToIdentifier(EnumBindingType enumBinding, Facet facet) {
        String enumValue = facet.getValue();
        try {
            int intVal = Integer.parseInt(facet.getValue());
            if (intVal >= 0) {
                return "VALUE_" + intVal;
            }
            return "VALUE_NEG_" + Math.abs(intVal);
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            String customMemberName = null;
            if (enumBinding != null) {
                EnumMember[] enumMembers = enumBinding.getEnumMember();
                for (int i = 0; i < enumMembers.length; ++i) {
                    if (!enumMembers[i].getValue().equals(enumValue)) continue;
                    customMemberName = enumMembers[i].getJavaName();
                }
            }
            if (customMemberName != null) {
                sb.append(customMemberName);
            } else {
                sb.append(enumValue.toUpperCase());
                for (int i = 0; i < sb.length(); ++i) {
                    char c = sb.charAt(i);
                    if ("[](){}<>'`\"".indexOf(c) >= 0) {
                        sb.deleteCharAt(i);
                        --i;
                        continue;
                    }
                    if (!Character.isWhitespace(c) && "\\/?~!@#$%^&*-+=:;.,".indexOf(c) < 0) continue;
                    sb.setCharAt(i, '_');
                }
            }
            return sb.toString();
        }
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    private static String escapeValue(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\"': 
                case '\'': 
                case '\\': {
                    sb.append('\\');
                    break;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

