/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.maven2.AbstractCargoMojo;
import org.codehaus.cargo.maven2.configuration.Deployable;

public class AbstractContainerStartMojo
extends AbstractCargoMojo {
    protected LocalContainer localContainer;

    public void doExecute() throws MojoExecutionException {
        Container container = this.createContainer();
        if (!container.getType().isLocal()) {
            throw new MojoExecutionException("Only local containers can be started");
        }
        this.localContainer = (LocalContainer)container;
        this.addAutoDeployDeployable(this.localContainer);
        this.localContainer.start();
        if (this.getConfigurationElement() != null && this.getConfigurationElement().getDeployables() != null) {
            for (Deployable deployable : this.getConfigurationElement().getDeployables()) {
                URL pingURL = deployable.getPingURL();
                if (pingURL == null) continue;
                Long pingTimeout = deployable.getPingTimeout();
                URLDeployableMonitor monitor = pingTimeout == null ? new URLDeployableMonitor(pingURL) : new URLDeployableMonitor(pingURL, pingTimeout.longValue());
                DeployerWatchdog watchdog = new DeployerWatchdog((DeployableMonitor)monitor);
                watchdog.watchForAvailability();
            }
        }
    }

    private void addAutoDeployDeployable(LocalContainer container) throws MojoExecutionException {
        if (this.getDeployerElement() == null && this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() && (this.getConfigurationElement() == null || this.getConfigurationElement().getDeployables() == null || !this.containsAutoDeployable(this.getConfigurationElement().getDeployables()))) {
            LocalConfiguration configuration = container.getConfiguration();
            configuration.addDeployable(this.createAutoDeployDeployable((Container)container));
        }
    }
}

