/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import org.apache.batik.anim.values.AnimatableMotionPointValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGLocatableSupport;
import org.apache.batik.dom.svg.SVGMotionAnimatableElement;
import org.apache.batik.dom.svg.SVGOMAnimatedBoolean;
import org.apache.batik.dom.svg.SVGOMAnimatedTransformList;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.svg.TraitInformation;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.util.DoublyIndexedTable;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStringList;

public abstract class SVGGraphicsElement
extends SVGStylableElement
implements SVGMotionAnimatableElement {
    protected static DoublyIndexedTable xmlTraitInformation;
    protected SVGOMAnimatedTransformList transform;
    protected SVGOMAnimatedBoolean externalResourcesRequired;
    protected AffineTransform motionTransform;

    protected SVGGraphicsElement() {
    }

    protected SVGGraphicsElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.initializeLiveAttributes();
    }

    @Override
    protected void initializeAllLiveAttributes() {
        super.initializeAllLiveAttributes();
        this.initializeLiveAttributes();
    }

    private void initializeLiveAttributes() {
        this.transform = this.createLiveAnimatedTransformList(null, "transform", "");
        this.externalResourcesRequired = this.createLiveAnimatedBoolean(null, "externalResourcesRequired", false);
    }

    @Override
    protected DoublyIndexedTable getTraitInformationTable() {
        return xmlTraitInformation;
    }

    public SVGElement getNearestViewportElement() {
        return SVGLocatableSupport.getNearestViewportElement(this);
    }

    public SVGElement getFarthestViewportElement() {
        return SVGLocatableSupport.getFarthestViewportElement(this);
    }

    public SVGRect getBBox() {
        return SVGLocatableSupport.getBBox(this);
    }

    public SVGMatrix getCTM() {
        return SVGLocatableSupport.getCTM(this);
    }

    public SVGMatrix getScreenCTM() {
        return SVGLocatableSupport.getScreenCTM(this);
    }

    public SVGMatrix getTransformToElement(SVGElement sVGElement) throws SVGException {
        return SVGLocatableSupport.getTransformToElement(this, sVGElement);
    }

    public SVGAnimatedTransformList getTransform() {
        return this.transform;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return this.externalResourcesRequired;
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang(this);
    }

    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace(this);
    }

    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures(this);
    }

    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions(this);
    }

    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage(this);
    }

    public boolean hasExtension(String string) {
        return SVGTestsSupport.hasExtension(this, string);
    }

    @Override
    public AffineTransform getMotionTransform() {
        return this.motionTransform;
    }

    @Override
    public void updateOtherValue(String string, AnimatableValue animatableValue) {
        if (string.equals("motion")) {
            Object object;
            if (this.motionTransform == null) {
                this.motionTransform = new AffineTransform();
            }
            if (animatableValue == null) {
                this.motionTransform.setToIdentity();
            } else {
                object = (AnimatableMotionPointValue)animatableValue;
                this.motionTransform.setToTranslation(((AnimatableMotionPointValue)object).getX(), ((AnimatableMotionPointValue)object).getY());
                this.motionTransform.rotate(((AnimatableMotionPointValue)object).getAngle());
            }
            object = (SVGOMDocument)this.ownerDocument;
            ((SVGOMDocument)object).getAnimatedAttributeListener().otherAnimationChanged(this, string);
        } else {
            super.updateOtherValue(string, animatableValue);
        }
    }

    static {
        DoublyIndexedTable doublyIndexedTable = new DoublyIndexedTable(SVGStylableElement.xmlTraitInformation);
        doublyIndexedTable.put(null, "transform", new TraitInformation(true, 9));
        doublyIndexedTable.put(null, "externalResourcesRequired", new TraitInformation(true, 49));
        xmlTraitInformation = doublyIndexedTable;
    }
}

