/*
 * #%L
 * Pollen :: VoteCounting strategy :: Condorcet
 * $Id: CondorcetVoteCountingStrategy.java 3710 2012-09-29 21:18:12Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.4/pollen-votecounting-condorcet/src/main/java/org/chorem/pollen/votecounting/CondorcetVoteCountingStrategy.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;

import java.util.Map;
import java.util.Set;

/**
 * Condorcet.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class CondorcetVoteCountingStrategy extends AbstractVoteCountingStrategy {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CondorcetVoteCountingStrategy.class);

    @Override
    public VoteCountingResult votecount(Set<Voter> voters) {

        // get empty result by choice
        Map<String, ChoiceScore> scores = newEmptyChoiceScoreMap(voters);

        for (Voter voter : voters) {

            // add this voter votes to result
            addVoterChoices(voter, scores);
        }

        // order scores (using their value) and return result
        VoteCountingResult result = orderByValues(scores.values());
        return result;
    }

    protected void addVoterChoices(Voter voter,
                                   Map<String, ChoiceScore> scores) {

        if (log.isDebugEnabled()) {
            log.debug("Start count for voter " + voter.getVoterId());
        }
        double voterWeight = voter.getWeight();

        for (VoteForChoice voteForChoiceX : voter.getVoteForChoices()) {

            String choiceIdX = voteForChoiceX.getChoiceId();

            double score = 0;

            for (VoteForChoice voteForChoiceY : voter.getVoteForChoices()) {

                if (choiceIdX.equals(voteForChoiceY.getChoiceId())) {
                    // no battle for same choice
                    continue;
                }
                int compare = voteValueComparator.compare(voteForChoiceX,
                                                          voteForChoiceY);

                if (compare < 0) {

                    // X wins over Y;
                    score += voterWeight;
                }
            }

            // store new score for this choice
            ChoiceScore choiceScore = scores.get(choiceIdX);
            choiceScore.addScoreValue(score);
        }
    }

}
