/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.base.AbstractLink;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.ui.components.FileLink;
import org.slf4j.Logger;

public class FileLink
extends AbstractLink {
    @Parameter(required=true)
    private String _src;
    @Parameter
    private String _type;
    @Inject
    private Logger logger;
    @Inject
    private ComponentResources _resources;

    void beginRender(MarkupWriter writer) {
        Link link = this._resources.createEventLink("createLink", new Object[]{this._src, this._type});
        this.writeLink(writer, link, new Object[0]);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public StreamResponse onCreateLink(String src, String type) {
        if (src == null || "".equals(src)) {
            return null;
        }
        File file = new File(src);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Fichier inexistant : " + file.getAbsolutePath(), (Throwable)e);
        }
        if (!this._resources.isBound("type")) {
            MimetypesFileTypeMap mimes = new MimetypesFileTypeMap();
            type = mimes.getContentType(file);
        }
        return new FileStreamResponse(this, (InputStream)stream, type);
    }
}

