/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.user;

import java.util.List;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.Retain;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.BeanModelSource;
import org.chorem.pollen.business.ServicePoll;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.data.EvenOdd;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.pages.poll.ClosePoll;

/**
 * Classe de la page d'affichage des sondages de l'utilisateur. Si l'utilisateur
 * n'est pas identifié, on lui demande d'abord de s'identifier via un
 * formulaire.
 *
 * @author kmorin
 * @author rannou
 * @version $Id: UserPolls.java 2615 2009-07-01 13:47:45Z nrannou $
 */
@IncludeStylesheet("context:css/polls.css")
public class UserPolls {

    /**
     * Objet de session représentant l'utilisateur identifié.
     */
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;

    /**
     * Liste de sondages de l'utilisateur
     */
    @SuppressWarnings("unused")
    @Property
    private List<PollDTO> polls;

    /**
     * Sondage servant à l'itération des sondages de la liste
     */
    @Property
    private PollDTO poll;

    /**
     * Objet servant à changer la couleur à chaque ligne de la liste des
     * sondages
     */
    @SuppressWarnings("unused")
    @Property
    private EvenOdd evenOdd;

    @Parameter(defaultPrefix = BindingConstants.MESSAGE, value = "title")
    @Property
    private String title;

    @SuppressWarnings("unused")
    @Property
    private Lien[] address;

    /**
     * Sert à créer pollsModel
     */
    @Inject
    private BeanModelSource beanModelSource;

    /**
     * Sert à passer les messages en paramètre de la création de pollsModel
     */
    @Inject
    private ComponentResources componentResources;

    /**
     * Modèle pour l'affichage de la liste des sondages
     */
    @SuppressWarnings("unchecked")
    @Property
    @Retain
    private BeanModel pollsModel;

    /** Page de validation de la fermeture d'un sondage */
    @InjectPage
    private ClosePoll closePoll;

    /** Injection des services */
    @Inject
    private ServicePoll servicePoll;

    /**
     * Méthode de création de l'identifiant d'administration du sondage.
     *
     * @return l'identifiant
     */
    public String getAdminId() {
        return poll.getPollId() + ":" + MD5.encode(poll.getCreatorId());
    }

    /**
     * Redirection vers la page de validation lors de la fermeture du sondage.
     *
     * @return la page de validation
     */
    Object onActionFromClose(String id) {
        closePoll.setPoll(servicePoll.findPollByPollId(id));
        return closePoll;
    }

    /**
     * Méthode d'initialisation des sondages
     */
    void onActivate() {
        evenOdd = new EvenOdd();
        if (userExists) {
            polls = servicePoll.findPollsByUser(user.getId());
        }
    }

    /**
     * Initialisation de l'affichage
     */
    void setupRender() {
        address = new Lien[] { new Lien("Pollen", "Index"),
                new Lien(title, null) };

        pollsModel = beanModelSource.createDisplayModel(PollDTO.class,
                componentResources.getMessages());
        pollsModel.add("functions", null);
        pollsModel.include("title", "description", "beginChoiceDate",
                "beginDate", "endDate", "functions");
    }

}
