/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.ParameterAware;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.exceptions.FavoriteListNotFoundException;
import org.chorem.pollen.services.exceptions.FavoriteListNotOwnedByUserException;
import org.chorem.pollen.services.exceptions.ParticipantAlreadyFoundInListException;
import org.chorem.pollen.ui.actions.PollenActionSupportForEdition;
import org.nuiton.util.StringUtil;

public class EditFavoriteListVoter
extends PollenActionSupportForEdition
implements Preparable,
ParameterAware {
    private static final long serialVersionUID = 1L;
    protected PersonList favoriteList;
    protected PollAccount editPollAccount;

    public PollAccount getEditPollAccount() {
        if (this.editPollAccount == null) {
            this.editPollAccount = this.getFavoriteService().newPollAccountForFavoriteList();
        }
        return this.editPollAccount;
    }

    public PersonList getFavoriteList() {
        return this.favoriteList;
    }

    public String getFavoriteListId() {
        return this.favoriteList.getTopiaId();
    }

    public String getAction() {
        return "edit";
    }

    public void prepare() throws Exception {
        String[] favoriteListIds = (String[])this.getParameters().get("favoriteListId");
        Preconditions.checkNotNull((Object)favoriteListIds);
        Preconditions.checkArgument((favoriteListIds.length == 1 ? 1 : 0) != 0);
        String favoriteListId = favoriteListIds[0];
        try {
            this.favoriteList = this.getFavoriteService().getFavoriteList(this.getPollenUserAccount(), favoriteListId);
        }
        catch (FavoriteListNotFoundException e) {
            this.addFlashError(this._("pollen.error.favoriteList.not.found", new Object[0]));
        }
        catch (FavoriteListNotOwnedByUserException e) {
            this.addFlashError(this._("pollen.error.favoriteList.not.owned.by.user", new Object[0]));
        }
    }

    public void validate() {
        PollAccount account = this.getEditPollAccount();
        if (StringUtils.isBlank((CharSequence)account.getVotingId())) {
            this.addFieldError("editPollAccount.votingId", this._("pollen.error.pollAccount.votingId.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)account.getEmail())) {
            this.addFieldError("editPollAccount.email", this._("pollen.error.email.required", new Object[0]));
        } else if (!StringUtil.isEmail((String)account.getEmail())) {
            this.addFieldError("editPollAccount.email", this._("pollen.error.email.invalid", new Object[0]));
        }
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.favoriteList);
        Preconditions.checkNotNull((Object)this.editPollAccount);
        String result = "input";
        try {
            this.getFavoriteService().editPollAccountToFavoriteList(this.favoriteList, this.editPollAccount);
            this.addFlashMessage(this._("pollen.information.pollAccount.updatedTofavoriteList", new Object[]{this.editPollAccount.getVotingId()}));
            this.editPollAccount = null;
            result = "success";
        }
        catch (ParticipantAlreadyFoundInListException e) {
            this.addFieldError("editPollAccount.email", this._("pollen.error.favoriteList.participant.already.found.in.list", new Object[0]));
        }
        return result;
    }
}

