<%--
  #%L
  Pollen :: UI (struts2)
  $Id: pollListHelper.jsp 3519 2012-06-19 08:18:29Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/pollListHelper.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:url id="loadUrl" action="getPolls" namespace="/json"/>

<s:url id="voteUrl" action="votefor/" namespace="/poll"/>
<s:url id='voteImg' value='/img/vote.png'/>
<s:set id='voteTitle'><s:text name="pollen.action.pollVote"/></s:set>

<s:url id='blankImg' value='/img/blank.png'/>

<s:url id="summaryUrl" action="summary/" namespace="/poll"/>
<s:url id='summaryImg' value='/img/edit.png'/>
<s:set id='summaryTitle'><s:text name="pollen.action.pollSummary"/></s:set>

<s:url id="resultUrl" action="results/" namespace="/poll"/>
<s:url id='resultImg' value='/img/count.png'/>
<s:set id='resultTitle'><s:text name="pollen.action.pollResult"/></s:set>

<s:url id="deleteUrl" action="confirmDeletePoll/" namespace="/poll"/>
<s:url id='deleteImg' value='/img/delete.png'/>
<s:set id='deleteTitle'><s:text name="pollen.action.pollDelete"/></s:set>

<script type="text/javascript">

  function confirmDelete(id) {
    $('.ui-dialog-title').html("<s:text name="pollen.title.delete.poll"/>")
    var dialog = $("#confirmDialog");
    var url = "<s:url action='confirmDeletePoll/' namespace='/poll'/>";
    url += id + '?' + $.param({redirectUrl:redirectUrl});
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }

  function confirmClose(id) {
    $('.ui-dialog-title').html("<s:text name="pollen.title.close.poll"/>")
    var dialog = $("#confirmDialog");
    var url = "<s:url action='confirmClosePoll/' namespace='/poll'/>";
    url += id + '?' + $.param({redirectUrl:redirectUrl});
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }

  function pollFunctions(cellvalue, options, rowObject) {

    var id = rowObject.pollId;
    var voteId = rowObject.voteId;
    var moderateId = rowObject.moderateId;
    var resultId = rowObject.resultId;
    var adminId = rowObject.adminId;

    var result = "";

    if (cellvalue.indexOf('vote') > -1) {
      result += formatLink("${voteUrl}" + voteId, "${voteImg}", "Vote", "${voteTitle}")
    }
    if (cellvalue.indexOf('novote') > -1) {
      result += "<image src='${blankImg}'>";
    }
    if (cellvalue.indexOf('summary') > -1) {
      result += formatLink("${summaryUrl}" + adminId, "${summaryImg}", "Moderate", "${summaryTitle}")
    }
    if (cellvalue.indexOf('moderate') > -1) {
      result += formatLink("${voteUrl}" + moderateId, "${moderateImg}", "Moderate", "${moderateTitle}")
    }
    if (cellvalue.indexOf('result') > -1) {
      result += formatLink("${resultUrl}" + resultId, "${resultImg}", "Result", "${resultTitle}")
    }
    if (cellvalue.indexOf('edit') > -1) {
      result += formatLink("${editUrl}" + adminId, "${editImg}", "Edit", "${editTitle}")
    }
    if (cellvalue.indexOf('close') > -1) {
      var script = 'return confirmClose("' + adminId + '");'
      result += formatLinkByScript(script, "${closeImg}", "Close", "${closeTitle}")
    }
    if (cellvalue.indexOf('export') > -1) {
      result += formatLink("${exportUrl}" + id, "${exportImg}", "Export", "${exportTitle}")
    }
    if (cellvalue.indexOf('clone') > -1) {
      result += formatLink("${cloneUrl}" + adminId, "${cloneImg}", "Clone", "${cloneTitle}")
    }
    if (cellvalue.indexOf('delete') > -1) {
      var script = 'return confirmDelete("' + adminId + '");'
      result += formatLinkByScript(script, "${deleteImg}", "Delete", "${deleteTitle}")
    }
    return result;
  }
  function formatLink(url, image, imageAlt, imageTitle) {
    return "<a href='" + url + "'><image alt='" + imageAlt + "' title='" + imageTitle + "' src='" + image + "'> </a>";
  }
  function formatLinkByScript(script, image, imageAlt, imageTitle) {
    return "<a href='#' onclick='" + script + "'><image alt='" + imageAlt + "' title='" + imageTitle + "' src='" + image + "'> </a>";
  }
</script>

<sj:dialog id="confirmDialog" autoOpen="false" modal="true" width="500"/>

