/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.UsersRight;
import org.chorem.pollen.persistence.entity.CommentVisibility;
import org.chorem.pollen.persistence.entity.PollType;
import org.chorem.pollen.persistence.entity.ResultVisibility;
import org.chorem.pollen.persistence.entity.VoteVisibility;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.config.GeneratedPollenServicesConfig;
import org.chorem.pollen.services.config.PollenServicesConfigOption;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollenServicesConfig
extends GeneratedPollenServicesConfig {
    private static final Logger log = LoggerFactory.getLogger(PollenServicesConfig.class);
    public static final String VERSION = "pollen.version";
    public static final String BUILD_DATE = "pollen.buildDate";
    public static final String COMMIT_ID = "pollen.commitId";
    private static final Set<String> KEYS_TO_HIDE = Set.of("secret", "password");

    public PollenServicesConfig(String filename) {
        this(filename, null);
    }

    public PollenServicesConfig(String filename, Properties defaultValues) {
        if (log.isInfoEnabled()) {
            String defaultValuesString = Optional.ofNullable(defaultValues).map(dv -> String.format(" with %d default values", dv.size())).orElse("");
            log.info("Loading PollenServicesConfig from '{}'{}", (Object)filename, (Object)defaultValuesString);
        }
        ApplicationConfig applicationConfig = this.get();
        applicationConfig.setAppName("pollen");
        applicationConfig.setConfigFileName(filename);
        if (defaultValues != null) {
            for (Map.Entry<Object, Object> entry : defaultValues.entrySet()) {
                applicationConfig.setOption((String)entry.getKey(), (String)entry.getValue());
            }
        }
        try {
            applicationConfig.parse(new String[0]);
        }
        catch (ArgumentsParserException e) {
            throw new PollenTechnicalException(e);
        }
        PollenServicesConfig.logConfigValues(filename, applicationConfig);
        this.validate();
    }

    private static void logConfigValues(String filename, ApplicationConfig applicationConfig) {
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("Pollen configuration:");
            builder.append("\nFilename: ").append(filename);
            for (PollenServicesConfigOption option : PollenServicesConfigOption.values()) {
                String optionKey = option.getKey();
                String value = Optional.ofNullable((String)applicationConfig.getOption(String.class, optionKey)).map(nonNullValue -> PollenServicesConfig.hideConfig(optionKey) ? "********" : nonNullValue).orElse("<empty>");
                builder.append(String.format("\n%1$-46s = %2$s", optionKey, value));
            }
            log.info(builder.toString());
        }
    }

    private static boolean hideConfig(String key) {
        return KEYS_TO_HIDE.stream().anyMatch(str -> key.toLowerCase().contains((CharSequence)str));
    }

    private void validate() {
        Optional<File> dataDirectoryOptional = Optional.ofNullable(this.getDataDirectory());
        dataDirectoryOptional.ifPresent(PollenServicesConfig::validateDataDirectory);
    }

    private static void validateDataDirectory(File dataDirectory) {
        if (dataDirectory.exists()) {
            Preconditions.checkArgument((boolean)dataDirectory.isDirectory(), (Object)(String.valueOf(dataDirectory) + " exists but is not a directory"));
            Preconditions.checkArgument((boolean)dataDirectory.canWrite(), (Object)(String.valueOf(dataDirectory) + " directory exists but it is not writable"));
        } else {
            if (log.isInfoEnabled()) {
                log.info("will create " + String.valueOf(dataDirectory));
            }
            boolean created = dataDirectory.mkdirs();
            Preconditions.checkState((boolean)created, (Object)("unable to create " + String.valueOf(dataDirectory)));
        }
    }

    public Map<String, String> getPersistenceProperties() {
        HashMap topiaParameters = Maps.newHashMap();
        Properties properties = this.get().getOptionStartsWith("hibernate");
        properties.putAll((Map<?, ?>)this.get().getOptionStartsWith("topia"));
        properties.putAll((Map<?, ?>)this.get().getOptionStartsWith("jakarta"));
        for (Object o : properties.keySet()) {
            String key = String.valueOf(o);
            String value = (String)this.get().getOption(String.class, key);
            topiaParameters.put(key, value);
        }
        return topiaParameters;
    }

    public boolean isLogConfigurationProvided() {
        return StringUtils.isNotBlank((CharSequence)this.get().getOption(PollenServicesConfigOption.LOG_CONFIGURATION_FILE.getKey()));
    }

    public String getHashAlgorithmName() {
        return "SHA-512";
    }

    @Override
    public PollType getDefaultPollType() {
        return PollType.valueOf((String)this.get().getOption(PollenServicesConfigOption.DEFAULT_POLL_TYPE.getKey()));
    }

    @Override
    public VoteVisibility getDefaultVoteVisibility() {
        return VoteVisibility.valueOf((String)this.get().getOption(PollenServicesConfigOption.DEFAULT_VOTE_VISIBILITY.getKey()));
    }

    @Override
    public CommentVisibility getDefaultCommentVisibility() {
        return CommentVisibility.valueOf((String)this.get().getOption(PollenServicesConfigOption.DEFAULT_COMMENT_VISIBILITY.getKey()));
    }

    @Override
    public ResultVisibility getDefaultResultVisibility() {
        return ResultVisibility.valueOf((String)this.get().getOption(PollenServicesConfigOption.DEFAULT_RESULT_VISIBILITY.getKey()));
    }

    @Override
    public Boolean getDefaultContinuousResults() {
        return Boolean.valueOf(this.get().getOption(PollenServicesConfigOption.DEFAULT_CONTINUOUS_RESULTS.getKey()));
    }

    @Override
    public Boolean getDefaultVoteNotification() {
        return Boolean.valueOf(this.get().getOption(PollenServicesConfigOption.DEFAULT_VOTE_NOTIFICATION.getKey()));
    }

    @Override
    public Boolean getDefaultCommentNotification() {
        return Boolean.valueOf(this.get().getOption(PollenServicesConfigOption.DEFAULT_COMMENT_NOTIFICATION.getKey()));
    }

    @Override
    public Boolean getDefaultNewChoiceNotification() {
        return Boolean.valueOf(this.get().getOption(PollenServicesConfigOption.DEFAULT_NEW_CHOICE_NOTIFICATION.getKey()));
    }

    public List<String> getMailsFeedbackList() {
        String feedbackEmailAddresses = this.get().getOption(PollenServicesConfigOption.MAILS_FEEDBACK.getKey());
        return Optional.ofNullable(feedbackEmailAddresses).map(s -> s.split(",")).map(Arrays::asList).orElseGet(List::of);
    }

    public Locale getFeedbackLocale() {
        return Locale.forLanguageTag(this.get().getOption(PollenServicesConfigOption.LOCALE_FEEDBACK.getKey()));
    }

    public TimeZone getDefaultTimeZone() {
        return TimeZone.getTimeZone(this.get().getOption(PollenServicesConfigOption.DEFAULT_TIME_ZONE_ID.getKey()));
    }

    @Override
    public UsersRight getUsersCanCreatePoll() {
        return UsersRight.valueOf((String)this.get().getOption(PollenServicesConfigOption.USERS_CAN_CREATE_POLL.getKey()));
    }

    public String getVersion() {
        return this.get().getOption(VERSION);
    }

    public String getBuildDate() {
        return this.get().getOption(BUILD_DATE);
    }

    public String getCommitId() {
        return this.get().getOption(COMMIT_ID);
    }

    public byte[] getTokenSecretBytes() {
        String secret = Optional.ofNullable(this.getTokenSecret()).orElseThrow(() -> new PollenTechnicalException("Required property '" + PollenServicesConfigOption.TOKEN_SECRET.getKey() + "' is missing"));
        byte[] decoded = Base64.getDecoder().decode(secret);
        if (decoded.length != 16 && decoded.length != 24 && decoded.length != 32) {
            throw new PollenTechnicalException("keyBytes wrong length for AES key");
        }
        return decoded;
    }

    @Override
    public Boolean getTokenCookieSecure() {
        return Boolean.valueOf(this.get().getOption(PollenServicesConfigOption.TOKEN_COOKIE_SECURE.getKey()));
    }
}

