/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.job;

import java.util.Collection;
import java.util.Locale;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.services.job.AbstractPollenJob;
import org.chorem.pollen.services.service.NotificationService;
import org.chorem.pollen.services.service.PollService;
import org.quartz.DisallowConcurrentExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public class SendPollEndReminderJob
extends AbstractPollenJob {
    private static final Logger log = LoggerFactory.getLogger(SendPollEndReminderJob.class);

    @Override
    protected String getDescription() {
        return "Send reminder emails to the poll owners";
    }

    @Override
    protected void execute() {
        PollService pollService = this.newService(PollService.class);
        Collection<Poll> pollsWithVoteReminderNeeded = pollService.getPollsWithReminderNeeded();
        for (Poll poll : pollsWithVoteReminderNeeded) {
            if (log.isDebugEnabled()) {
                log.debug("Send reminder for poll " + poll.getTitle());
            }
            try {
                Locale locale = poll.getNotificationLocale() != null ? Locale.forLanguageTag(poll.getNotificationLocale()) : Locale.getDefault();
                NotificationService notificationService = this.newService(NotificationService.class);
                notificationService.sendPollEndReminder(poll, locale);
                poll.setPollEndReminderSent(true);
                pollService.commit();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error("Error while sending end reminder for poll " + poll.getTopiaId(), (Throwable)e);
            }
        }
    }
}

