/*
 * #%L
 * Pollen :: Services
 * $Id: PollenMigrationCallbackV1_1.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.3/pollen-services/src/main/java/org/chorem/pollen/entities/migration/PollenMigrationCallbackV1_1.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.entities.migration;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClassNG;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

import java.util.Arrays;
import java.util.List;

/**
 * Migration for version {@code 1.1}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenMigrationCallbackV1_1 extends TopiaMigrationCallbackByClassNG.MigrationCallBackForVersion {

    @Override
    public Version getVersion() {
        return VersionUtil.valueOf("1.1");
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx,
                                          List<String> queries,
                                          boolean showSql,
                                          boolean showProgression) throws TopiaException {


        Dialect dialect =
                Dialect.getDialect(tx.getHibernateConfiguration().getProperties());

        String[] sqls = null;

        // Script de migration
        if (dialect instanceof PostgreSQLDialect) {
            sqls = new String[]{
                    "alter table useraccount rename langage to language;",
                    "alter table pollaccount add accountid varchar;",
                    "update pollaccount set accountid=md5(topiaid);",
                    "alter table persontolist drop column hasvoted;",
                    "alter table persontolist add hasvoted boolean default false;",
                    "alter table vote add anonymous boolean default false;",
                    "alter table preventrule add active boolean default true;",
                    "alter table preventrule add onetime boolean default false;",};
        } else if (dialect instanceof H2Dialect) {
            sqls = new String[]{
                    "alter table useraccount alter column langage rename to language;",
                    "alter table pollaccount add accountid varchar;",
                    "update pollaccount set accountid=hash('sha256', stringtoutf8(topiaid), 1000);",
                    "alter table persontolist drop column hasvoted;",
                    "alter table persontolist add hasvoted boolean default false;",
                    "alter table vote add anonymous boolean default false;",
                    "alter table preventrule add active boolean default true;",
                    "alter table preventrule add onetime boolean default false;",};
        }

        queries.addAll(Arrays.asList(sqls));

    }
}
