/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.impl.EmailService;

public class PreventRuleService
extends PollenServiceSupport {
    public static final String SCOPE_VOTE = "vote";
    public static final String SCOPE_REMINDER = "rappel";
    private static final Log log = LogFactory.getLog(PreventRuleService.class);

    public PreventRule createAddVotePreventRule() {
        PreventRule rule = (PreventRule)this.newInstance(this.getDAO(PreventRule.class));
        rule.setScope(SCOPE_VOTE);
        rule.setSensibility(1);
        rule.setRepeated(true);
        return rule;
    }

    public PreventRule createRemindPreventRule(int sensibility) {
        PreventRule rule = (PreventRule)this.newInstance(this.getDAO(PreventRule.class));
        rule.setScope(SCOPE_REMINDER);
        rule.setSensibility(sensibility);
        rule.setRepeated(false);
        return rule;
    }

    public void onVoteAdded(Poll poll) {
        if (poll.getEndDate() != null) {
            for (PreventRule rule : poll.getPreventRule()) {
                if (!this.canExecuteRule(SCOPE_VOTE, rule, 1)) continue;
                EmailService emailService = this.newService(EmailService.class);
                emailService.onVoteAdded(poll);
                this.commitTransaction("Could not update prevent rule");
            }
        }
    }

    public void onPollToRemind(Poll poll, Date now) {
        Preconditions.checkNotNull((Object)poll, (Object)"Poll can notbe nul.");
        Date endDate = poll.getEndDate();
        Preconditions.checkNotNull((Object)endDate, (Object)"End date can not be null to remind");
        long timeValue = endDate.getTime() - now.getTime();
        int hourBeforeEnd = (int)(timeValue / 3600000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Now: " + now.getTime() + " End: " + endDate.getTime() + " timeValue: " + timeValue + "(" + hourBeforeEnd + "h)"));
        }
        for (PreventRule rule : poll.getPreventRule()) {
            if (!this.canExecuteRule(SCOPE_REMINDER, rule, hourBeforeEnd)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Execute reminder rule on poll " + poll.getTitle()));
            }
            EmailService emailService = this.newService(EmailService.class);
            emailService.onPollReminder(poll);
            rule.setActive(false);
            this.commitTransaction("Could not update prevent rule");
        }
    }

    protected boolean canExecuteRule(String scope, PreventRule preventRule, Integer value) {
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkNotNull((Object)value);
        boolean result = false;
        if (preventRule.isActive() && scope.equals(preventRule.getScope())) {
            int sensibility = preventRule.getSensibility();
            if (preventRule.isRepeated() && sensibility != 0) {
                value = value % sensibility + sensibility;
            }
            if (value == sensibility) {
                result = true;
            }
        }
        return result;
    }
}

