/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAO;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.FavoriteListAlreadyExistException;
import org.chorem.pollen.services.exceptions.FavoriteListImportException;
import org.chorem.pollen.services.exceptions.FavoriteListNotFoundException;
import org.chorem.pollen.services.exceptions.FavoriteListNotOwnedByUserException;
import org.chorem.pollen.services.exceptions.ParticipantAlreadyFoundInListException;
import org.chorem.pollen.services.exceptions.ParticipantNotFoundException;
import org.chorem.pollen.services.exceptions.ParticipantNotFoundInListException;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;
import org.nuiton.util.StringUtil;

public class FavoriteService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(FavoriteService.class);

    public List<PersonList> getFavoriteLists(UserAccount user, TopiaFilterPagerUtil.FilterPagerBean pager) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)pager);
        try {
            PersonListDAO dao = (PersonListDAO)this.getDAO(PersonList.class);
            List result = dao.findFavoriteLists(user, pager);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public List<PersonList> getFavoriteLists(UserAccount user) {
        Preconditions.checkNotNull((Object)user);
        try {
            PersonListDAO dao = (PersonListDAO)this.getDAO(PersonList.class);
            List result = dao.findAllFavoriteLists(user);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public PersonList getFavoriteList(UserAccount user, String favoriteListId) throws FavoriteListNotFoundException, FavoriteListNotOwnedByUserException {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)favoriteListId);
        try {
            PersonListDAO dao = (PersonListDAO)this.getDAO(PersonList.class);
            PersonList favoriteList = (PersonList)dao.findByTopiaId(favoriteListId);
            if (favoriteList == null) {
                throw new FavoriteListNotFoundException();
            }
            UserAccount favoriteListOwner = favoriteList.getOwner();
            if (!favoriteListOwner.equals(user)) {
                throw new FavoriteListNotOwnedByUserException();
            }
            return favoriteList;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public List<PollAccount> getFavoriteListUsers(PersonList favoriteList, TopiaFilterPagerUtil.FilterPagerBean pager) {
        Preconditions.checkNotNull((Object)favoriteList);
        Preconditions.checkNotNull((Object)pager);
        try {
            PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
            List result = dao.findFavoriteListUsers(favoriteList, pager);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public PersonList createFavoriteList(UserAccount user, String name) throws FavoriteListAlreadyExistException, UserNotFoundException {
        PersonList result;
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name));
        UserAccountDAO userDAO = (UserAccountDAO)this.getDAO(UserAccount.class);
        PersonListDAO dao = (PersonListDAO)this.getDAO(PersonList.class);
        try {
            UserAccount userToUse = (UserAccount)userDAO.findByTopiaId(user.getTopiaId());
            if (userToUse == null) {
                throw new UserNotFoundException();
            }
            boolean exist = dao.isPersonListExist(user, name);
            if (exist) {
                throw new FavoriteListAlreadyExistException();
            }
            result = (PersonList)dao.create(new Object[]{"owner", userToUse});
            result.setName(name);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
        return result;
    }

    public PersonList deleteFavoriteList(UserAccount user, PersonList favoriteList) throws FavoriteListNotFoundException, FavoriteListNotOwnedByUserException, UserNotFoundException {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)favoriteList);
        UserAccountDAO userDAO = (UserAccountDAO)this.getDAO(UserAccount.class);
        PersonListDAO dao = (PersonListDAO)this.getDAO(PersonList.class);
        try {
            UserAccount userToUse = (UserAccount)userDAO.findByTopiaId(user.getTopiaId());
            if (userToUse == null) {
                throw new UserNotFoundException();
            }
            PersonList favoriteListToDelete = (PersonList)dao.findByTopiaId(favoriteList.getTopiaId());
            if (favoriteListToDelete == null) {
                throw new FavoriteListNotFoundException();
            }
            UserAccount favoriteListOwner = favoriteListToDelete.getOwner();
            if (!favoriteListOwner.equals(user)) {
                throw new FavoriteListNotOwnedByUserException();
            }
            dao.delete(favoriteListToDelete);
            this.commitTransaction("Could not delete favorite list");
            return favoriteListToDelete;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public void addPollAccountToFavoriteList(PersonList favoriteList, PollAccount pollAccount) throws ParticipantAlreadyFoundInListException, FavoriteListNotFoundException {
        Preconditions.checkNotNull((Object)favoriteList);
        Preconditions.checkNotNull((Object)pollAccount);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pollAccount.getVotingId()));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pollAccount.getEmail()));
        PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
        PersonListDAO personListDAO = (PersonListDAO)this.getDAO(PersonList.class);
        try {
            PersonList personListToUpdate = (PersonList)personListDAO.findByTopiaId(favoriteList.getTopiaId());
            if (personListToUpdate == null) {
                throw new FavoriteListNotFoundException();
            }
            boolean pollAccountExists = dao.isPollAccountExists(personListToUpdate, pollAccount);
            if (pollAccountExists) {
                throw new ParticipantAlreadyFoundInListException();
            }
            PollAccount pollAccountCreated = (PollAccount)dao.create(new Object[]{"personList", personListToUpdate});
            pollAccountCreated.setVotingId(pollAccount.getVotingId());
            pollAccountCreated.setEmail(pollAccount.getEmail());
            personListToUpdate.addPollAccount(pollAccountCreated);
            this.commitTransaction("Could not add poll account to favorite list");
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public void editPollAccountToFavoriteList(PersonList favoriteList, PollAccount pollAccount) throws ParticipantAlreadyFoundInListException, FavoriteListNotFoundException, ParticipantNotFoundException {
        Preconditions.checkNotNull((Object)favoriteList);
        Preconditions.checkNotNull((Object)pollAccount);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pollAccount.getVotingId()));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pollAccount.getEmail()));
        PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
        PersonListDAO personListDAO = (PersonListDAO)this.getDAO(PersonList.class);
        try {
            PersonList personListToUpdate = (PersonList)personListDAO.findByTopiaId(favoriteList.getTopiaId());
            if (personListToUpdate == null) {
                throw new FavoriteListNotFoundException();
            }
            PollAccount pollAccountToUpdate = (PollAccount)dao.findByTopiaId(pollAccount.getTopiaId());
            if (pollAccountToUpdate == null) {
                throw new ParticipantNotFoundException();
            }
            boolean pollAccountExists = dao.isPollAccountExists(personListToUpdate, pollAccount);
            if (pollAccountExists) {
                throw new ParticipantAlreadyFoundInListException();
            }
            pollAccountToUpdate.setVotingId(pollAccount.getVotingId());
            pollAccountToUpdate.setEmail(pollAccount.getEmail());
            this.commitTransaction("Could not edit poll account favorite list");
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public void removePollAccountToFavoriteList(PersonList favoriteList, PollAccount pollAccount) throws ParticipantNotFoundException, FavoriteListNotFoundException, ParticipantNotFoundInListException {
        Preconditions.checkNotNull((Object)favoriteList);
        Preconditions.checkNotNull((Object)pollAccount);
        PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
        PersonListDAO personListDAO = (PersonListDAO)this.getDAO(PersonList.class);
        try {
            PersonList personListToUpdate = (PersonList)personListDAO.findByTopiaId(favoriteList.getTopiaId());
            if (personListToUpdate == null) {
                throw new FavoriteListNotFoundException();
            }
            PollAccount pollAccountToRemove = (PollAccount)dao.findByTopiaId(pollAccount.getTopiaId());
            if (pollAccountToRemove == null) {
                throw new ParticipantNotFoundException();
            }
            PollAccount pollAccountInList = personListToUpdate.getPollAccountByTopiaId(pollAccount.getTopiaId());
            if (pollAccountInList == null) {
                throw new ParticipantNotFoundInListException();
            }
            personListToUpdate.removePollAccount(pollAccountToRemove);
            this.commitTransaction("Could not remove pollaccount to favorite list");
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<PollAccount> importFromCsvfile(String filename, File file) throws FavoriteListImportException {
        ArrayList results = Lists.newArrayList();
        Locale locale = this.getLocale();
        PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                String votingId;
                String email;
                if (StringUtils.isBlank((CharSequence)(line = line.trim())) || line.startsWith("#")) continue;
                ++lineNumber;
                int spaceIndex = line.indexOf(32);
                if (spaceIndex == -1) {
                    email = line;
                    votingId = line;
                } else {
                    email = line.substring(0, spaceIndex);
                    votingId = line.substring(spaceIndex);
                }
                email = email.trim();
                votingId = votingId.trim();
                if (!StringUtil.isEmail((String)email)) {
                    String error = I18n.l_((Locale)locale, (String)"pollen.error.import.invalid.email", (Object[])new Object[]{lineNumber, email});
                    throw new FavoriteListImportException(filename, error, null);
                }
                PollAccount account = (PollAccount)this.newInstance(dao);
                account.setEmail(email);
                account.setVotingId(votingId);
                results.add(account);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(results.size() + " comptes import\u00e9s."));
            }
            reader.close();
            IOUtils.closeQuietly((Reader)reader);
            return results;
        }
        catch (FileNotFoundException ex) {
            throw new PollenTechnicalException((Throwable)ex);
            catch (IOException e) {
                if (!log.isErrorEnabled()) return results;
                log.error((Object)"Could not close reader", (Throwable)e);
                return results;
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public List<PollAccount> importFromLDAP(String url) throws FavoriteListImportException {
        long start = System.nanoTime();
        ArrayList results = Lists.newArrayList();
        try {
            Properties env = new Properties();
            InitialDirContext ictx = new InitialDirContext(env);
            SearchControls control = new SearchControls();
            control.setSearchScope(2);
            NamingEnumeration<SearchResult> e = ictx.search(url, null, control);
            while (e.hasMore()) {
                SearchResult r = e.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result: " + r.getName() + "(object: " + r.getClassName() + ")"));
                }
                Attribute nameAttr = r.getAttributes().get("cn");
                Attribute emailAttr = r.getAttributes().get("mail");
                if (nameAttr == null) continue;
                PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
                PollAccount account = (PollAccount)this.newInstance(dao);
                account.setVotingId(nameAttr.get().toString());
                account.setEmail(emailAttr.get().toString());
                results.add(account);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("New account - name: " + nameAttr.get().toString() + ", email: " + emailAttr.get().toString()));
            }
        }
        catch (NamingException ex) {
            log.error((Object)"Exception de nommage lors de l'import depuis LDAP", (Throwable)ex);
            throw new FavoriteListImportException("LDAP", ex);
        }
        long duration = (System.nanoTime() - start) / 1000000000L;
        if (log.isInfoEnabled()) {
            log.info((Object)(results.size() + " comptes import\u00e9s en " + duration + " sec."));
        }
        return results;
    }

    public PersonList newFavoriteList() {
        PersonListDAO dao = (PersonListDAO)this.getDAO(PersonList.class);
        PersonList personList = (PersonList)this.newInstance(dao);
        return personList;
    }

    public PollAccount newPollAccountForFavoriteList() {
        PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
        PollAccount pollAccount = (PollAccount)this.newInstance(dao);
        return pollAccount;
    }
}

