/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenFunctions;
import org.chorem.pollen.bean.PollResult;
import org.chorem.pollen.bean.PollResultList;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.persistence.ResultDAO;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.PollExportDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.services.ImportExportService;
import org.chorem.pollen.votecounting.services.VoteCountingService;
import org.nuiton.i18n.I18n;

public class PollResultsService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(PollResultsService.class);

    public PollResultList getResults(Poll poll) {
        VoteCountingResultDTO result;
        Preconditions.checkNotNull((Object)poll);
        if (!poll.isResultUptodate()) {
            result = this.generateResult(poll);
            this.commitTransaction("Could not generate poll result");
        } else {
            result = this.getResultDTO(poll);
        }
        boolean byGroup = poll.getPollType() == PollType.GROUP;
        int voteCountingType = poll.getVoteCountingType();
        List list = Lists.transform((List)poll.getResult(), PollenServiceFunctions.newResultToBeanFunction(poll));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            PollResult currentResult = (PollResult)it.next();
            if (!byGroup || currentResult.isByGroup()) continue;
            it.remove();
        }
        PollResultList resultList = new PollResultList();
        resultList.setPollResults(list);
        resultList.setVoteCountingResult(result);
        return resultList;
    }

    public VoteCountingResultDTO generateResult(Poll poll) {
        Preconditions.checkNotNull((Object)poll);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will regenerate results for poll " + poll.getPollId()));
        }
        VoteCountingResultDTO result = this.getResultDTO(poll);
        poll.clearResult();
        ResultDAO daoResult = (ResultDAO)this.getDAO(Result.class);
        for (ChoiceDTO choice : result.getChoices()) {
            Result eResult = (Result)this.create(daoResult);
            Choice eChoice = poll.getChoiceByTopiaId(choice.getIdChoice());
            eResult.setName(eChoice.getName());
            eResult.setByGroup(result.isByGroup());
            eResult.setResultValue(String.valueOf(choice.getValue()));
            eResult.setVoteCountingType(poll.getVoteCountingType());
            poll.addResult(eResult);
        }
        poll.setResultUptodate(true);
        return result;
    }

    public String exportPolltoXml(String pollId) throws PollNotFoundException {
        PollService pollService = this.newService(PollService.class);
        Poll poll = pollService.getExistingPollByPollId(pollId);
        PollDTO dto = (PollDTO)PollenFunctions.POLL_TO_BEAN.apply((Object)poll);
        VoteCountingService service = new VoteCountingService();
        ArrayList results = Lists.newArrayList();
        VoteCountingResultDTO result = service.executeVoteCounting(dto);
        results.add(result);
        if (poll.getPollType() == PollType.GROUP) {
            VoteCountingResultDTO groupResult = service.executeGroupCounting(dto);
            results.add(groupResult);
        }
        PollExportDTO pollExport = new PollExportDTO();
        pollExport.setPollId(pollId);
        pollExport.setPoll(dto);
        pollExport.setVoteCountingResults((List)results);
        ImportExportService serviceExport = new ImportExportService();
        String content = serviceExport.exportToXml(pollExport);
        return content;
    }

    public String getResultValue(Choice choice, Collection<PollResult> results) {
        String val = "";
        for (PollResult result : results) {
            if (!result.getName().equals(choice.getName())) continue;
            val = this.removeTrailing0(result.getValue());
            break;
        }
        return val;
    }

    public List<PollResult> createNumberVoteCountingResult(PollResultList resultListDTO, Multimap<String, String> choicesResults, Multimap<String, String> subtitles) {
        Preconditions.checkNotNull((Object)resultListDTO);
        Preconditions.checkNotNull(choicesResults);
        Preconditions.checkNotNull(subtitles);
        List<PollResult> results = resultListDTO.getPollResults();
        ArrayList results2 = Lists.newArrayList();
        for (PollResult result : results) {
            if (result.isHidden()) {
                String name = result.getName();
                int indexOf = name.indexOf(35);
                String choice = name.substring("HIDDEN_".length(), indexOf);
                String votingId = name.substring(indexOf + 1);
                String value = result.getValue();
                choicesResults.put((Object)choice, (Object)votingId);
                choicesResults.put((Object)choice, (Object)value);
                continue;
            }
            results2.add(result);
        }
        Locale locale = this.getLocale();
        VoteCountingResultDTO voteCountingResult = resultListDTO.getVoteCountingResult();
        block1: for (String choiceName : choicesResults.keySet()) {
            Collection values = choicesResults.get((Object)choiceName);
            for (ChoiceDTO choice : voteCountingResult.getChoices()) {
                if (!choiceName.equals(choice.getName())) continue;
                subtitles.put((Object)choiceName, (Object)I18n.l_((Locale)locale, (String)"pollen.common.numberVote-total", (Object[])new Object[0]));
                subtitles.put((Object)choiceName, (Object)String.valueOf(choice.getValue()));
                subtitles.put((Object)choiceName, (Object)I18n.l_((Locale)locale, (String)"pollen.common.numberVote-average", (Object[])new Object[0]));
                subtitles.put((Object)choiceName, (Object)String.valueOf(choice.getAverage()));
                subtitles.put((Object)choiceName, (Object)I18n.l_((Locale)locale, (String)"pollen.common.numberVote-blank-votes", (Object[])new Object[0]));
                subtitles.put((Object)choiceName, (Object)String.valueOf(choice.getNbBlankVotes()));
                subtitles.put((Object)choiceName, (Object)I18n.l_((Locale)locale, (String)"pollen.common.numberVote-total-votes", (Object[])new Object[0]));
                subtitles.put((Object)choiceName, (Object)String.valueOf(values.size() / 2));
                continue block1;
            }
        }
        if (results2.size() == 1) {
            results2.remove(0);
        }
        return results2;
    }

    public List<PollResult> getTopRanking(List<PollResult> results) {
        ArrayList ranking = Lists.newArrayList(results);
        Collections.sort(ranking, new Comparator<PollResult>(){

            @Override
            public int compare(PollResult o1, PollResult o2) {
                Double result1 = Double.parseDouble(o1.getValue());
                Double result2 = Double.parseDouble(o2.getValue());
                int comp = 0;
                if (result1 > result2) {
                    comp = -1;
                } else if (result1 < result2) {
                    comp = 1;
                }
                if (comp == 0) {
                    comp = o1.getName().compareTo(o2.getName());
                }
                return comp;
            }
        });
        ArrayList topRanking = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)ranking)) {
            String winValue = ((PollResult)ranking.get(0)).getValue();
            for (PollResult r : ranking) {
                if (!winValue.equals(r.getValue())) continue;
                topRanking.add(r);
            }
        }
        return topRanking;
    }

    protected String removeTrailing0(String val) {
        if (val.endsWith(".0")) {
            val = val.substring(0, val.indexOf(46));
        }
        return val;
    }

    public String getResultsAsString(Poll poll) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getDateTimePattern());
        StringBuilder res = new StringBuilder("");
        Iterator it = poll.getResult().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            if (poll.getChoiceType() == ChoiceType.DATE) {
                Date date = new Date(Long.parseLong(result.getName()));
                res.append(dateFormat.format(date));
            } else {
                res.append(result.getName());
            }
            res.append("=").append(this.removeTrailing0(result.getResultValue()));
            if (!it.hasNext()) continue;
            res.append(", ");
        }
        return res.toString();
    }

    protected VoteCountingResultDTO getResultDTO(Poll poll) {
        PollDTO dto = (PollDTO)PollenFunctions.POLL_TO_BEAN.apply((Object)poll);
        dto.setVoteCounting(poll.getVoteCountingType());
        VoteCountingService service = new VoteCountingService();
        VoteCountingResultDTO result = service.execute(dto);
        return result;
    }
}

