/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.CommentDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.PollCommentNotFound;
import org.chorem.pollen.services.impl.PollFeedService;
import org.chorem.pollen.services.impl.PollService;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class PollCommentService
extends PollenServiceSupport {
    public Comment createComment(Poll poll, Comment comment) {
        Preconditions.checkNotNull((Object)poll);
        PollDAO pollDAO = (PollDAO)this.getDAO(Poll.class);
        CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
        try {
            Poll pollToUpdate = (Poll)pollDAO.findByTopiaId(poll.getTopiaId());
            Comment commentCreated = (Comment)dao.create(new Object[]{"poll", pollToUpdate, "postDate", comment.getPostDate(), "author", comment.getAuthor(), "text", comment.getText()});
            pollToUpdate.addComment(commentCreated);
            PollAccount pollAccount = comment.getPollAccount();
            if (pollAccount.getTopiaId() != null) {
                PollAccount pollAccountLoaded = this.getEntityById(PollAccount.class, pollAccount.getTopiaId());
                if (pollAccountLoaded.getUserAccount() == null && pollAccount.getUserAccount() != null) {
                    String userId = pollAccount.getUserAccount().getTopiaId();
                    UserAccount userAccountLoaded = this.getEntityById(UserAccount.class, userId);
                    pollAccountLoaded.setUserAccount(userAccountLoaded);
                }
                commentCreated.setPollAccount(pollAccountLoaded);
            }
            this.commitTransaction("Could not create comment (" + comment.getAuthor() + ") " + comment.getText());
            PollService pollService = this.newService(PollService.class);
            PollUrl pollVoteUrl = pollService.getPollVoteUrl(poll, false);
            PollFeedService pollFeedService = this.newService(PollFeedService.class);
            pollFeedService.onAddComment(commentCreated, pollVoteUrl);
            return commentCreated;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public void deleteComment(String commentId) throws PollCommentNotFound {
        Preconditions.checkNotNull((Object)commentId);
        CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
        try {
            Comment comment = (Comment)dao.findByTopiaId(commentId);
            if (comment == null) {
                throw new PollCommentNotFound();
            }
            dao.delete((TopiaEntity)comment);
            this.commitTransaction("Could not delete comment " + comment.getText());
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public Comment getNewComment(PollAccount account, String author, String text) {
        CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
        Comment result = (Comment)this.newInstance(dao);
        if (account != null) {
            result.setPollAccount(account);
        }
        result.setAuthor(author);
        result.setText(text);
        result.setPostDate(this.serviceContext.getCurrentTime());
        return result;
    }

    public boolean isCanDeleteComment(Comment comment, PollAccount pollAccount, UserAccount userAccount) {
        boolean result;
        PollAccount commentAccount = comment.getPollAccount();
        if (userAccount != null) {
            boolean isAdmin = userAccount.isAdministrator();
            boolean isCommentAccount = userAccount.equals(commentAccount.getUserAccount());
            result = isAdmin || isCommentAccount;
        } else {
            result = pollAccount != null ? pollAccount.equals(commentAccount) : false;
        }
        return result;
    }

    public List<Comment> getComments(TopiaFilterPagerUtil.FilterPagerBean pager, String pollId) {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)pollId);
        try {
            CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
            List result = dao.getComments(pager, pollId);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain comments", (Throwable)e);
        }
    }

    public List<Comment> getAllComments(String pollId) {
        Preconditions.checkNotNull((Object)pollId);
        try {
            CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
            List result = dao.getAllComments(pollId);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain comments", (Throwable)e);
        }
    }
}

