/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.services.FavoriteListImport;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.FavoriteListImportException;

public class FavoriteListImportLDAP
extends PollenServiceSupport
implements FavoriteListImport {
    private static final Log log = LogFactory.getLog(FavoriteListImportLDAP.class);

    @Override
    public List<PollAccount> execute(String url) throws FavoriteListImportException {
        long start = System.nanoTime();
        ArrayList results = Lists.newArrayList();
        try {
            Properties env = new Properties();
            InitialDirContext ictx = new InitialDirContext(env);
            SearchControls control = new SearchControls();
            control.setSearchScope(2);
            NamingEnumeration<SearchResult> e = ictx.search(url, null, control);
            while (e.hasMore()) {
                SearchResult r = e.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result: " + r.getName() + "(object: " + r.getClassName() + ")"));
                }
                Attribute nameAttr = r.getAttributes().get("cn");
                Attribute emailAttr = r.getAttributes().get("mail");
                if (nameAttr == null) continue;
                PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
                PollAccount account = (PollAccount)this.newInstance(dao);
                account.setVotingId(nameAttr.get().toString());
                account.setEmail(emailAttr.get().toString());
                results.add(account);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("New account - name: " + nameAttr.get().toString() + ", email: " + emailAttr.get().toString()));
            }
        }
        catch (NamingException ex) {
            log.error((Object)"Exception de nommage lors de l'import depuis LDAP", (Throwable)ex);
            throw new FavoriteListImportException("LDAP", ex);
        }
        long duration = (System.nanoTime() - start) / 1000000000L;
        if (log.isInfoEnabled()) {
            log.info((Object)(results.size() + " comptes import\u00e9s en " + duration + " sec."));
        }
        return results;
    }
}

