/*
 * #%L
 * Pollen :: Services
 * 
 * $Id: PollDateChoice.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-services/src/main/java/org/chorem/pollen/bean/PollDateChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.bean;

import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceImpl;

import java.util.Date;

/**
 * Extends the basic choice to keep the date (will be transformed to name)
 * (during poll creation).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollDateChoice extends ChoiceImpl {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_DATE = "date";

    protected Date date;

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void fromChoice(Choice choice) {
        setName(choice.getName());
        setDescription(choice.getDescription());
        setTopiaId(choice.getTopiaId());
        setValidate(choice.isValidate());
        setDate(new Date(Long.valueOf(choice.getName())));
    }

    public void toChoice(Choice choice) {
        choice.setName(String.valueOf(getDate().getTime()));
        choice.setDescription(getDescription());
        choice.setValidate(isValidate());
    }
}
